# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud.models.workflow_transition_property import WorkflowTransitionProperty

from devopso.clients.jira_cloud.api_client import ApiClient, RequestSerialized
from devopso.clients.jira_cloud.api_response import ApiResponse
from devopso.clients.jira_cloud.rest import RESTResponseType


class WorkflowTransitionPropertiesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_workflow_transition_property(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The key of the property being added, also known as the name of the property. Set this to the same value as the `key` defined in the request body.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_transition_property: WorkflowTransitionProperty,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WorkflowTransitionProperty:
        """(Deprecated) Create workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); add transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Adds a property to a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The key of the property being added, also known as the name of the property. Set this to the same value as the `key` defined in the request body. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_transition_property: (required)
        :type workflow_transition_property: WorkflowTransitionProperty
        :param workflow_mode: The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._create_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_transition_property=workflow_transition_property,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_workflow_transition_property_with_http_info(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The key of the property being added, also known as the name of the property. Set this to the same value as the `key` defined in the request body.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_transition_property: WorkflowTransitionProperty,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WorkflowTransitionProperty]:
        """(Deprecated) Create workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); add transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Adds a property to a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The key of the property being added, also known as the name of the property. Set this to the same value as the `key` defined in the request body. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_transition_property: (required)
        :type workflow_transition_property: WorkflowTransitionProperty
        :param workflow_mode: The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._create_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_transition_property=workflow_transition_property,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_workflow_transition_property_without_preload_content(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The key of the property being added, also known as the name of the property. Set this to the same value as the `key` defined in the request body.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_transition_property: WorkflowTransitionProperty,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Create workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); add transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Adds a property to a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The key of the property being added, also known as the name of the property. Set this to the same value as the `key` defined in the request body. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_transition_property: (required)
        :type workflow_transition_property: WorkflowTransitionProperty
        :param workflow_mode: The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._create_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_transition_property=workflow_transition_property,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_workflow_transition_property_serialize(
        self,
        transition_id,
        key,
        workflow_name,
        workflow_transition_property,
        workflow_mode,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if transition_id is not None:
            _path_params['transitionId'] = transition_id
        # process the query parameters
        if key is not None:
            
            _query_params.append(('key', key))
            
        if workflow_name is not None:
            
            _query_params.append(('workflowName', workflow_name))
            
        if workflow_mode is not None:
            
            _query_params.append(('workflowMode', workflow_mode))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if workflow_transition_property is not None:
            _body_params = workflow_transition_property


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/rest/api/3/workflow/transitions/{transitionId}/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_workflow_transition_property(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The name of the transition property to delete, also known as the name of the property.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """(Deprecated) Delete workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); delete transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Deletes a property from a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The name of the transition property to delete, also known as the name of the property. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_mode: The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._delete_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '304': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_workflow_transition_property_with_http_info(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The name of the transition property to delete, also known as the name of the property.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """(Deprecated) Delete workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); delete transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Deletes a property from a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The name of the transition property to delete, also known as the name of the property. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_mode: The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._delete_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '304': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_workflow_transition_property_without_preload_content(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The name of the transition property to delete, also known as the name of the property.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Delete workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); delete transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Deletes a property from a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The name of the transition property to delete, also known as the name of the property. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_mode: The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("DELETE /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._delete_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '304': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_workflow_transition_property_serialize(
        self,
        transition_id,
        key,
        workflow_name,
        workflow_mode,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if transition_id is not None:
            _path_params['transitionId'] = transition_id
        # process the query parameters
        if key is not None:
            
            _query_params.append(('key', key))
            
        if workflow_name is not None:
            
            _query_params.append(('workflowName', workflow_name))
            
        if workflow_mode is not None:
            
            _query_params.append(('workflowMode', workflow_mode))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/rest/api/3/workflow/transitions/{transitionId}/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_workflow_transition_properties(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        include_reserved_keys: Annotated[Optional[StrictBool], Field(description="Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*.")] = None,
        key: Annotated[Optional[StrictStr], Field(description="The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned.")] = None,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WorkflowTransitionProperty:
        """(Deprecated) Get workflow transition properties

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); fetch transition properties from [Bulk get workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-post) instead.  Returns the properties on a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param include_reserved_keys: Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*.
        :type include_reserved_keys: bool
        :param key: The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned.
        :type key: str
        :param workflow_mode: The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._get_workflow_transition_properties_serialize(
            transition_id=transition_id,
            workflow_name=workflow_name,
            include_reserved_keys=include_reserved_keys,
            key=key,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_workflow_transition_properties_with_http_info(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        include_reserved_keys: Annotated[Optional[StrictBool], Field(description="Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*.")] = None,
        key: Annotated[Optional[StrictStr], Field(description="The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned.")] = None,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WorkflowTransitionProperty]:
        """(Deprecated) Get workflow transition properties

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); fetch transition properties from [Bulk get workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-post) instead.  Returns the properties on a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param include_reserved_keys: Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*.
        :type include_reserved_keys: bool
        :param key: The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned.
        :type key: str
        :param workflow_mode: The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._get_workflow_transition_properties_serialize(
            transition_id=transition_id,
            workflow_name=workflow_name,
            include_reserved_keys=include_reserved_keys,
            key=key,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_workflow_transition_properties_without_preload_content(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        include_reserved_keys: Annotated[Optional[StrictBool], Field(description="Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*.")] = None,
        key: Annotated[Optional[StrictStr], Field(description="The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned.")] = None,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Get workflow transition properties

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); fetch transition properties from [Bulk get workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-post) instead.  Returns the properties on a workflow transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param include_reserved_keys: Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*.
        :type include_reserved_keys: bool
        :param key: The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned.
        :type key: str
        :param workflow_mode: The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._get_workflow_transition_properties_serialize(
            transition_id=transition_id,
            workflow_name=workflow_name,
            include_reserved_keys=include_reserved_keys,
            key=key,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_workflow_transition_properties_serialize(
        self,
        transition_id,
        workflow_name,
        include_reserved_keys,
        key,
        workflow_mode,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if transition_id is not None:
            _path_params['transitionId'] = transition_id
        # process the query parameters
        if include_reserved_keys is not None:
            
            _query_params.append(('includeReservedKeys', include_reserved_keys))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if workflow_name is not None:
            
            _query_params.append(('workflowName', workflow_name))
            
        if workflow_mode is not None:
            
            _query_params.append(('workflowMode', workflow_mode))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/rest/api/3/workflow/transitions/{transitionId}/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_workflow_transition_property(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The key of the property being updated, also known as the name of the property. Set this to the same value as the `key` defined in the request body.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_transition_property: WorkflowTransitionProperty,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WorkflowTransitionProperty:
        """(Deprecated) Update workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); update transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Updates a workflow transition by changing the property value. Trying to update a property that does not exist results in a new property being added to the transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The key of the property being updated, also known as the name of the property. Set this to the same value as the `key` defined in the request body. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_transition_property: (required)
        :type workflow_transition_property: WorkflowTransitionProperty
        :param workflow_mode: The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._update_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_transition_property=workflow_transition_property,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '304': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_workflow_transition_property_with_http_info(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The key of the property being updated, also known as the name of the property. Set this to the same value as the `key` defined in the request body.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_transition_property: WorkflowTransitionProperty,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WorkflowTransitionProperty]:
        """(Deprecated) Update workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); update transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Updates a workflow transition by changing the property value. Trying to update a property that does not exist results in a new property being added to the transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The key of the property being updated, also known as the name of the property. Set this to the same value as the `key` defined in the request body. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_transition_property: (required)
        :type workflow_transition_property: WorkflowTransitionProperty
        :param workflow_mode: The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._update_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_transition_property=workflow_transition_property,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '304': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_workflow_transition_property_without_preload_content(
        self,
        transition_id: Annotated[StrictInt, Field(description="The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.")],
        key: Annotated[StrictStr, Field(description="The key of the property being updated, also known as the name of the property. Set this to the same value as the `key` defined in the request body.")],
        workflow_name: Annotated[StrictStr, Field(description="The name of the workflow that the transition belongs to.")],
        workflow_transition_property: WorkflowTransitionProperty,
        workflow_mode: Annotated[Optional[StrictStr], Field(description="The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Update workflow transition property

        This will be removed on [June 1, 2026](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-2570); update transition properties using [Bulk update workflows](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflows/#api-rest-api-3-workflows-update-post) instead.  Updates a workflow transition by changing the property value. Trying to update a property that does not exist results in a new property being added to the transition. Transition properties are used to change the behavior of a transition. For more information, see [Transition properties](https://confluence.atlassian.com/x/zIhKLg#Advancedworkflowconfiguration-transitionproperties) and [Workflow properties](https://confluence.atlassian.com/x/JYlKLg).  **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).

        :param transition_id: The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition. (required)
        :type transition_id: int
        :param key: The key of the property being updated, also known as the name of the property. Set this to the same value as the `key` defined in the request body. (required)
        :type key: str
        :param workflow_name: The name of the workflow that the transition belongs to. (required)
        :type workflow_name: str
        :param workflow_transition_property: (required)
        :type workflow_transition_property: WorkflowTransitionProperty
        :param workflow_mode: The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.
        :type workflow_mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("PUT /rest/api/3/workflow/transitions/{transitionId}/properties is deprecated.", DeprecationWarning)

        _param = self._update_workflow_transition_property_serialize(
            transition_id=transition_id,
            key=key,
            workflow_name=workflow_name,
            workflow_transition_property=workflow_transition_property,
            workflow_mode=workflow_mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WorkflowTransitionProperty",
            '304': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_workflow_transition_property_serialize(
        self,
        transition_id,
        key,
        workflow_name,
        workflow_transition_property,
        workflow_mode,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if transition_id is not None:
            _path_params['transitionId'] = transition_id
        # process the query parameters
        if key is not None:
            
            _query_params.append(('key', key))
            
        if workflow_name is not None:
            
            _query_params.append(('workflowName', workflow_name))
            
        if workflow_mode is not None:
            
            _query_params.append(('workflowMode', workflow_mode))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if workflow_transition_property is not None:
            _body_params = workflow_transition_property


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2', 
            'basicAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/rest/api/3/workflow/transitions/{transitionId}/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


