# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.group_name import GroupName
from typing import Optional, Set
from typing_extensions import Self

class ApplicationRole(BaseModel):
    """
    Details of an application role.
    """ # noqa: E501
    default_groups: Optional[List[StrictStr]] = Field(default=None, description="The groups that are granted default access for this application role. As a group's name can change, use of `defaultGroupsDetails` is recommended to identify a groups.", alias="defaultGroups")
    default_groups_details: Optional[List[GroupName]] = Field(default=None, description="The groups that are granted default access for this application role.", alias="defaultGroupsDetails")
    defined: Optional[StrictBool] = Field(default=None, description="Deprecated.")
    group_details: Optional[List[GroupName]] = Field(default=None, description="The groups associated with the application role.", alias="groupDetails")
    groups: Optional[List[StrictStr]] = Field(default=None, description="The groups associated with the application role. As a group's name can change, use of `groupDetails` is recommended to identify a groups.")
    has_unlimited_seats: Optional[StrictBool] = Field(default=None, alias="hasUnlimitedSeats")
    key: Optional[StrictStr] = Field(default=None, description="The key of the application role.")
    name: Optional[StrictStr] = Field(default=None, description="The display name of the application role.")
    number_of_seats: Optional[StrictInt] = Field(default=None, description="The maximum count of users on your license.", alias="numberOfSeats")
    platform: Optional[StrictBool] = Field(default=None, description="Indicates if the application role belongs to Jira platform (`jira-core`).")
    remaining_seats: Optional[StrictInt] = Field(default=None, description="The count of users remaining on your license.", alias="remainingSeats")
    selected_by_default: Optional[StrictBool] = Field(default=None, description="Determines whether this application role should be selected by default on user creation.", alias="selectedByDefault")
    user_count: Optional[StrictInt] = Field(default=None, description="The number of users counting against your license.", alias="userCount")
    user_count_description: Optional[StrictStr] = Field(default=None, description="The [type of users](https://confluence.atlassian.com/x/lRW3Ng) being counted against your license.", alias="userCountDescription")
    __properties: ClassVar[List[str]] = ["defaultGroups", "defaultGroupsDetails", "defined", "groupDetails", "groups", "hasUnlimitedSeats", "key", "name", "numberOfSeats", "platform", "remainingSeats", "selectedByDefault", "userCount", "userCountDescription"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApplicationRole from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in default_groups_details (list)
        _items = []
        if self.default_groups_details:
            for _item_default_groups_details in self.default_groups_details:
                if _item_default_groups_details:
                    _items.append(_item_default_groups_details.to_dict())
            _dict['defaultGroupsDetails'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in group_details (list)
        _items = []
        if self.group_details:
            for _item_group_details in self.group_details:
                if _item_group_details:
                    _items.append(_item_group_details.to_dict())
            _dict['groupDetails'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApplicationRole from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultGroups": obj.get("defaultGroups"),
            "defaultGroupsDetails": [GroupName.from_dict(_item) for _item in obj["defaultGroupsDetails"]] if obj.get("defaultGroupsDetails") is not None else None,
            "defined": obj.get("defined"),
            "groupDetails": [GroupName.from_dict(_item) for _item in obj["groupDetails"]] if obj.get("groupDetails") is not None else None,
            "groups": obj.get("groups"),
            "hasUnlimitedSeats": obj.get("hasUnlimitedSeats"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "numberOfSeats": obj.get("numberOfSeats"),
            "platform": obj.get("platform"),
            "remainingSeats": obj.get("remainingSeats"),
            "selectedByDefault": obj.get("selectedByDefault"),
            "userCount": obj.get("userCount"),
            "userCountDescription": obj.get("userCountDescription")
        })
        return _obj


