# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ApprovalConfiguration(BaseModel):
    """
    The approval configuration of a status within a workflow. Applies only to Jira Service Management approvals.
    """ # noqa: E501
    active: StrictStr = Field(description="Whether the approval configuration is active.")
    condition_type: StrictStr = Field(description="How the required approval count is calculated. It may be configured to require a specific number of approvals, or approval by a percentage of approvers. If the approvers source field is Approver groups, you can configure how many approvals per group are required for the request to be approved. The number will be the same across all groups.", alias="conditionType")
    condition_value: StrictStr = Field(description="The number or percentage of approvals required for a request to be approved. If `conditionType` is `number`, the value must be 20 or less. If `conditionType` is `percent`, the value must be 100 or less.", alias="conditionValue")
    exclude: Optional[List[Optional[StrictStr]]] = Field(default=None, description="A list of roles that should be excluded as possible approvers.")
    field_id: StrictStr = Field(description="The custom field ID of the \"Approvers\" or \"Approver Groups\" field.", alias="fieldId")
    pre_populated_field_id: Optional[StrictStr] = Field(default=None, description="The custom field ID of the field used to pre-populate the Approver field. Only supports the \"Affected Services\" field.", alias="prePopulatedFieldId")
    transition_approved: StrictStr = Field(description="The numeric ID of the transition to be executed if the request is approved.", alias="transitionApproved")
    transition_rejected: StrictStr = Field(description="The numeric ID of the transition to be executed if the request is declined.", alias="transitionRejected")
    __properties: ClassVar[List[str]] = ["active", "conditionType", "conditionValue", "exclude", "fieldId", "prePopulatedFieldId", "transitionApproved", "transitionRejected"]

    @field_validator('active')
    def active_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    @field_validator('condition_type')
    def condition_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['number', 'percent', 'numberPerPrincipal']):
            raise ValueError("must be one of enum values ('number', 'percent', 'numberPerPrincipal')")
        return value

    @field_validator('exclude')
    def exclude_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['assignee', 'reporter']):
                raise ValueError("each list item must be one of ('assignee', 'reporter')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApprovalConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if exclude (nullable) is None
        # and model_fields_set contains the field
        if self.exclude is None and "exclude" in self.model_fields_set:
            _dict['exclude'] = None

        # set to None if pre_populated_field_id (nullable) is None
        # and model_fields_set contains the field
        if self.pre_populated_field_id is None and "pre_populated_field_id" in self.model_fields_set:
            _dict['prePopulatedFieldId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApprovalConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active": obj.get("active"),
            "conditionType": obj.get("conditionType"),
            "conditionValue": obj.get("conditionValue"),
            "exclude": obj.get("exclude"),
            "fieldId": obj.get("fieldId"),
            "prePopulatedFieldId": obj.get("prePopulatedFieldId"),
            "transitionApproved": obj.get("transitionApproved"),
            "transitionRejected": obj.get("transitionRejected")
        })
        return _obj


