# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class AttachmentMetadata(BaseModel):
    """
    Metadata for an issue attachment.
    """ # noqa: E501
    author: Optional[User] = Field(default=None, description="Details of the user who attached the file.")
    content: Optional[StrictStr] = Field(default=None, description="The URL of the attachment.")
    created: Optional[datetime] = Field(default=None, description="The datetime the attachment was created.")
    filename: Optional[StrictStr] = Field(default=None, description="The name of the attachment file.")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the attachment.")
    mime_type: Optional[StrictStr] = Field(default=None, description="The MIME type of the attachment.", alias="mimeType")
    properties: Optional[Dict[str, Any]] = Field(default=None, description="Additional properties of the attachment.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the attachment metadata details.", alias="self")
    size: Optional[StrictInt] = Field(default=None, description="The size of the attachment.")
    thumbnail: Optional[StrictStr] = Field(default=None, description="The URL of a thumbnail representing the attachment.")
    __properties: ClassVar[List[str]] = ["author", "content", "created", "filename", "id", "mimeType", "properties", "self", "size", "thumbnail"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AttachmentMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "author",
            "content",
            "created",
            "filename",
            "id",
            "mime_type",
            "properties",
            "var_self",
            "size",
            "thumbnail",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AttachmentMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": User.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "content": obj.get("content"),
            "created": obj.get("created"),
            "filename": obj.get("filename"),
            "id": obj.get("id"),
            "mimeType": obj.get("mimeType"),
            "properties": obj.get("properties"),
            "self": obj.get("self"),
            "size": obj.get("size"),
            "thumbnail": obj.get("thumbnail")
        })
        return _obj


