# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.associated_item_bean import AssociatedItemBean
from devopso.clients.jira_cloud.models.changed_value_bean import ChangedValueBean
from typing import Optional, Set
from typing_extensions import Self

class AuditRecordBean(BaseModel):
    """
    An audit record.
    """ # noqa: E501
    associated_items: Optional[List[AssociatedItemBean]] = Field(default=None, description="The list of items associated with the changed record.", alias="associatedItems")
    author_key: Optional[StrictStr] = Field(default=None, description="Deprecated, use `authorAccountId` instead. The key of the user who created the audit record.", alias="authorKey")
    category: Optional[StrictStr] = Field(default=None, description="The category of the audit record. For a list of these categories, see the help article [Auditing in Jira applications](https://confluence.atlassian.com/x/noXKM).")
    changed_values: Optional[List[ChangedValueBean]] = Field(default=None, description="The list of values changed in the record event.", alias="changedValues")
    created: Optional[datetime] = Field(default=None, description="The date and time on which the audit record was created.")
    description: Optional[StrictStr] = Field(default=None, description="The description of the audit record.")
    event_source: Optional[StrictStr] = Field(default=None, description="The event the audit record originated from.", alias="eventSource")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the audit record.")
    object_item: Optional[AssociatedItemBean] = Field(default=None, alias="objectItem")
    remote_address: Optional[StrictStr] = Field(default=None, description="The URL of the computer where the creation of the audit record was initiated.", alias="remoteAddress")
    summary: Optional[StrictStr] = Field(default=None, description="The summary of the audit record.")
    __properties: ClassVar[List[str]] = ["associatedItems", "authorKey", "category", "changedValues", "created", "description", "eventSource", "id", "objectItem", "remoteAddress", "summary"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuditRecordBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "associated_items",
            "author_key",
            "category",
            "changed_values",
            "created",
            "description",
            "event_source",
            "id",
            "remote_address",
            "summary",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associated_items (list)
        _items = []
        if self.associated_items:
            for _item_associated_items in self.associated_items:
                if _item_associated_items:
                    _items.append(_item_associated_items.to_dict())
            _dict['associatedItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in changed_values (list)
        _items = []
        if self.changed_values:
            for _item_changed_values in self.changed_values:
                if _item_changed_values:
                    _items.append(_item_changed_values.to_dict())
            _dict['changedValues'] = _items
        # override the default output from pydantic by calling `to_dict()` of object_item
        if self.object_item:
            _dict['objectItem'] = self.object_item.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuditRecordBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "associatedItems": [AssociatedItemBean.from_dict(_item) for _item in obj["associatedItems"]] if obj.get("associatedItems") is not None else None,
            "authorKey": obj.get("authorKey"),
            "category": obj.get("category"),
            "changedValues": [ChangedValueBean.from_dict(_item) for _item in obj["changedValues"]] if obj.get("changedValues") is not None else None,
            "created": obj.get("created"),
            "description": obj.get("description"),
            "eventSource": obj.get("eventSource"),
            "id": obj.get("id"),
            "objectItem": AssociatedItemBean.from_dict(obj["objectItem"]) if obj.get("objectItem") is not None else None,
            "remoteAddress": obj.get("remoteAddress"),
            "summary": obj.get("summary")
        })
        return _obj


