# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AvailableWorkflowConnectRule(BaseModel):
    """
    The Connect provided ecosystem rules available.
    """ # noqa: E501
    addon_key: Optional[StrictStr] = Field(default=None, description="The add-on providing the rule.", alias="addonKey")
    create_url: Optional[StrictStr] = Field(default=None, description="The URL creation path segment defined in the Connect module.", alias="createUrl")
    description: Optional[StrictStr] = Field(default=None, description="The rule description.")
    edit_url: Optional[StrictStr] = Field(default=None, description="The URL edit path segment defined in the Connect module.", alias="editUrl")
    module_key: Optional[StrictStr] = Field(default=None, description="The module providing the rule.", alias="moduleKey")
    name: Optional[StrictStr] = Field(default=None, description="The rule name.")
    rule_key: Optional[StrictStr] = Field(default=None, description="The rule key.", alias="ruleKey")
    rule_type: Optional[StrictStr] = Field(default=None, description="The rule type.", alias="ruleType")
    view_url: Optional[StrictStr] = Field(default=None, description="The URL view path segment defined in the Connect module.", alias="viewUrl")
    __properties: ClassVar[List[str]] = ["addonKey", "createUrl", "description", "editUrl", "moduleKey", "name", "ruleKey", "ruleType", "viewUrl"]

    @field_validator('rule_type')
    def rule_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Condition', 'Validator', 'Function', 'Screen']):
            raise ValueError("must be one of enum values ('Condition', 'Validator', 'Function', 'Screen')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AvailableWorkflowConnectRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AvailableWorkflowConnectRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addonKey": obj.get("addonKey"),
            "createUrl": obj.get("createUrl"),
            "description": obj.get("description"),
            "editUrl": obj.get("editUrl"),
            "moduleKey": obj.get("moduleKey"),
            "name": obj.get("name"),
            "ruleKey": obj.get("ruleKey"),
            "ruleType": obj.get("ruleType"),
            "viewUrl": obj.get("viewUrl")
        })
        return _obj


