# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.board_column_payload import BoardColumnPayload
from devopso.clients.jira_cloud.models.board_feature_payload import BoardFeaturePayload
from devopso.clients.jira_cloud.models.card_layout import CardLayout
from devopso.clients.jira_cloud.models.card_layout_field import CardLayoutField
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from devopso.clients.jira_cloud.models.quick_filter_payload import QuickFilterPayload
from devopso.clients.jira_cloud.models.swimlanes_payload import SwimlanesPayload
from devopso.clients.jira_cloud.models.working_days_config import WorkingDaysConfig
from typing import Optional, Set
from typing_extensions import Self

class BoardPayload(BaseModel):
    """
    The payload for creating a board
    """ # noqa: E501
    board_filter_jql: Optional[StrictStr] = Field(default=None, description="Takes in a JQL string to create a new filter. If no value is provided, it'll default to a JQL filter for the project creating", alias="boardFilterJQL")
    card_color_strategy: Optional[StrictStr] = Field(default=None, description="Card color settings of the board", alias="cardColorStrategy")
    card_layout: Optional[CardLayout] = Field(default=None, alias="cardLayout")
    card_layouts: Optional[List[CardLayoutField]] = Field(default=None, description="Card layout settings of the board", alias="cardLayouts")
    columns: Optional[List[BoardColumnPayload]] = Field(default=None, description="The columns of the board")
    features: Optional[List[BoardFeaturePayload]] = Field(default=None, description="Feature settings for the board")
    name: Optional[StrictStr] = Field(default=None, description="The name of the board")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    quick_filters: Optional[List[QuickFilterPayload]] = Field(default=None, description="The quick filters for the board.", alias="quickFilters")
    supports_sprint: Optional[StrictBool] = Field(default=True, description="Whether sprints are supported on the board", alias="supportsSprint")
    swimlanes: Optional[SwimlanesPayload] = None
    working_days_config: Optional[WorkingDaysConfig] = Field(default=None, alias="workingDaysConfig")
    __properties: ClassVar[List[str]] = ["boardFilterJQL", "cardColorStrategy", "cardLayout", "cardLayouts", "columns", "features", "name", "pcri", "quickFilters", "supportsSprint", "swimlanes", "workingDaysConfig"]

    @field_validator('card_color_strategy')
    def card_color_strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ISSUE_TYPE', 'REQUEST_TYPE', 'ASSIGNEE', 'PRIORITY', 'NONE', 'CUSTOM']):
            raise ValueError("must be one of enum values ('ISSUE_TYPE', 'REQUEST_TYPE', 'ASSIGNEE', 'PRIORITY', 'NONE', 'CUSTOM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BoardPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of card_layout
        if self.card_layout:
            _dict['cardLayout'] = self.card_layout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in card_layouts (list)
        _items = []
        if self.card_layouts:
            for _item_card_layouts in self.card_layouts:
                if _item_card_layouts:
                    _items.append(_item_card_layouts.to_dict())
            _dict['cardLayouts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item_columns in self.columns:
                if _item_columns:
                    _items.append(_item_columns.to_dict())
            _dict['columns'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in features (list)
        _items = []
        if self.features:
            for _item_features in self.features:
                if _item_features:
                    _items.append(_item_features.to_dict())
            _dict['features'] = _items
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in quick_filters (list)
        _items = []
        if self.quick_filters:
            for _item_quick_filters in self.quick_filters:
                if _item_quick_filters:
                    _items.append(_item_quick_filters.to_dict())
            _dict['quickFilters'] = _items
        # override the default output from pydantic by calling `to_dict()` of swimlanes
        if self.swimlanes:
            _dict['swimlanes'] = self.swimlanes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of working_days_config
        if self.working_days_config:
            _dict['workingDaysConfig'] = self.working_days_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BoardPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "boardFilterJQL": obj.get("boardFilterJQL"),
            "cardColorStrategy": obj.get("cardColorStrategy"),
            "cardLayout": CardLayout.from_dict(obj["cardLayout"]) if obj.get("cardLayout") is not None else None,
            "cardLayouts": [CardLayoutField.from_dict(_item) for _item in obj["cardLayouts"]] if obj.get("cardLayouts") is not None else None,
            "columns": [BoardColumnPayload.from_dict(_item) for _item in obj["columns"]] if obj.get("columns") is not None else None,
            "features": [BoardFeaturePayload.from_dict(_item) for _item in obj["features"]] if obj.get("features") is not None else None,
            "name": obj.get("name"),
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None,
            "quickFilters": [QuickFilterPayload.from_dict(_item) for _item in obj["quickFilters"]] if obj.get("quickFilters") is not None else None,
            "supportsSprint": obj.get("supportsSprint") if obj.get("supportsSprint") is not None else True,
            "swimlanes": SwimlanesPayload.from_dict(obj["swimlanes"]) if obj.get("swimlanes") is not None else None,
            "workingDaysConfig": WorkingDaysConfig.from_dict(obj["workingDaysConfig"]) if obj.get("workingDaysConfig") is not None else None
        })
        return _obj


