# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class BulkChangelogRequestBean(BaseModel):
    """
    Request bean for bulk changelog retrieval
    """ # noqa: E501
    field_ids: Optional[Annotated[List[StrictStr], Field(min_length=0, max_length=10)]] = Field(default=None, description="List of field IDs to filter changelogs", alias="fieldIds")
    issue_ids_or_keys: Annotated[List[StrictStr], Field(min_length=1, max_length=1000)] = Field(description="List of issue IDs/keys to fetch changelogs for", alias="issueIdsOrKeys")
    max_results: Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]] = Field(default=1000, description="The maximum number of items to return per page", alias="maxResults")
    next_page_token: Optional[StrictStr] = Field(default=None, description="The cursor for pagination", alias="nextPageToken")
    __properties: ClassVar[List[str]] = ["fieldIds", "issueIdsOrKeys", "maxResults", "nextPageToken"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BulkChangelogRequestBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BulkChangelogRequestBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fieldIds": obj.get("fieldIds"),
            "issueIdsOrKeys": obj.get("issueIdsOrKeys"),
            "maxResults": obj.get("maxResults") if obj.get("maxResults") is not None else 1000,
            "nextPageToken": obj.get("nextPageToken")
        })
        return _obj


