# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.issue_change_log import IssueChangeLog
from typing import Optional, Set
from typing_extensions import Self

class BulkChangelogResponseBean(BaseModel):
    """
    A page of changelogs which is designed to handle multiple issues
    """ # noqa: E501
    issue_change_logs: Optional[List[IssueChangeLog]] = Field(default=None, description="The list of issues changelogs.", alias="issueChangeLogs")
    next_page_token: Optional[StrictStr] = Field(default=None, description="Continuation token to fetch the next page. If this result represents the last or the only page, this token will be null.", alias="nextPageToken")
    __properties: ClassVar[List[str]] = ["issueChangeLogs", "nextPageToken"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BulkChangelogResponseBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "issue_change_logs",
            "next_page_token",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in issue_change_logs (list)
        _items = []
        if self.issue_change_logs:
            for _item_issue_change_logs in self.issue_change_logs:
                if _item_issue_change_logs:
                    _items.append(_item_issue_change_logs.to_dict())
            _dict['issueChangeLogs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BulkChangelogResponseBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "issueChangeLogs": [IssueChangeLog.from_dict(_item) for _item in obj["issueChangeLogs"]] if obj.get("issueChangeLogs") is not None else None,
            "nextPageToken": obj.get("nextPageToken")
        })
        return _obj


