# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class BulkOperationProgress(BaseModel):
    """
    BulkOperationProgress
    """ # noqa: E501
    created: Optional[datetime] = Field(default=None, description="A timestamp of when the task was submitted.")
    failed_accessible_issues: Optional[Dict[str, List[StrictStr]]] = Field(default=None, description="Map of issue IDs for which the operation failed and that the user has permission to view, to their one or more reasons for failure. These reasons are open-ended text descriptions of the error and are not selected from a predefined list of standard reasons.", alias="failedAccessibleIssues")
    invalid_or_inaccessible_issue_count: Optional[StrictInt] = Field(default=None, description="The number of issues that are either invalid or issues that the user doesn't have permission to view, regardless of the success or failure of the operation.", alias="invalidOrInaccessibleIssueCount")
    processed_accessible_issues: Optional[List[StrictInt]] = Field(default=None, description="List of issue IDs for which the operation was successful and that the user has permission to view.", alias="processedAccessibleIssues")
    progress_percent: Optional[StrictInt] = Field(default=None, description="Progress of the task as a percentage.", alias="progressPercent")
    started: Optional[datetime] = Field(default=None, description="A timestamp of when the task was started.")
    status: Optional[StrictStr] = Field(default=None, description="The status of the task.")
    submitted_by: Optional[User] = Field(default=None, alias="submittedBy")
    task_id: Optional[StrictStr] = Field(default=None, description="The ID of the task.", alias="taskId")
    total_issue_count: Optional[StrictInt] = Field(default=None, description="The number of issues that the bulk operation was attempted on.", alias="totalIssueCount")
    updated: Optional[datetime] = Field(default=None, description="A timestamp of when the task progress was last updated.")
    __properties: ClassVar[List[str]] = ["created", "failedAccessibleIssues", "invalidOrInaccessibleIssueCount", "processedAccessibleIssues", "progressPercent", "started", "status", "submittedBy", "taskId", "totalIssueCount", "updated"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ENQUEUED', 'RUNNING', 'COMPLETE', 'FAILED', 'CANCEL_REQUESTED', 'CANCELLED', 'DEAD']):
            raise ValueError("must be one of enum values ('ENQUEUED', 'RUNNING', 'COMPLETE', 'FAILED', 'CANCEL_REQUESTED', 'CANCELLED', 'DEAD')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BulkOperationProgress from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "task_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of submitted_by
        if self.submitted_by:
            _dict['submittedBy'] = self.submitted_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BulkOperationProgress from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created": obj.get("created"),
            "failedAccessibleIssues": obj.get("failedAccessibleIssues"),
            "invalidOrInaccessibleIssueCount": obj.get("invalidOrInaccessibleIssueCount"),
            "processedAccessibleIssues": obj.get("processedAccessibleIssues"),
            "progressPercent": obj.get("progressPercent"),
            "started": obj.get("started"),
            "status": obj.get("status"),
            "submittedBy": User.from_dict(obj["submittedBy"]) if obj.get("submittedBy") is not None else None,
            "taskId": obj.get("taskId"),
            "totalIssueCount": obj.get("totalIssueCount"),
            "updated": obj.get("updated")
        })
        return _obj


