# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.issue_bulk_transition_for_workflow import IssueBulkTransitionForWorkflow
from typing import Optional, Set
from typing_extensions import Self

class BulkTransitionGetAvailableTransitions(BaseModel):
    """
    Bulk Transition Get Available Transitions Response.
    """ # noqa: E501
    available_transitions: Optional[List[IssueBulkTransitionForWorkflow]] = Field(default=None, description="List of available transitions for bulk transition operation for requested issues grouped by workflow", alias="availableTransitions")
    ending_before: Optional[StrictStr] = Field(default=None, description="The end cursor for use in pagination.", alias="endingBefore")
    starting_after: Optional[StrictStr] = Field(default=None, description="The start cursor for use in pagination.", alias="startingAfter")
    __properties: ClassVar[List[str]] = ["availableTransitions", "endingBefore", "startingAfter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BulkTransitionGetAvailableTransitions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "available_transitions",
            "ending_before",
            "starting_after",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in available_transitions (list)
        _items = []
        if self.available_transitions:
            for _item_available_transitions in self.available_transitions:
                if _item_available_transitions:
                    _items.append(_item_available_transitions.to_dict())
            _dict['availableTransitions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BulkTransitionGetAvailableTransitions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "availableTransitions": [IssueBulkTransitionForWorkflow.from_dict(_item) for _item in obj["availableTransitions"]] if obj.get("availableTransitions") is not None else None,
            "endingBefore": obj.get("endingBefore"),
            "startingAfter": obj.get("startingAfter")
        })
        return _obj


