# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.entity_property import EntityProperty
from devopso.clients.jira_cloud.models.user_details import UserDetails
from devopso.clients.jira_cloud.models.visibility import Visibility
from typing import Optional, Set
from typing_extensions import Self

class Comment(BaseModel):
    """
    A comment.
    """ # noqa: E501
    author: Optional[UserDetails] = Field(default=None, description="The ID of the user who created the comment.")
    body: Optional[Any] = Field(default=None, description="The comment text in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/).")
    created: Optional[datetime] = Field(default=None, description="The date and time at which the comment was created.")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the comment.")
    jsd_author_can_see_request: Optional[StrictBool] = Field(default=None, description="Whether the comment was added from an email sent by a person who is not part of the issue. See [Allow external emails to be added as comments on issues](https://support.atlassian.com/jira-service-management-cloud/docs/allow-external-emails-to-be-added-as-comments-on-issues/)for information on setting up this feature.", alias="jsdAuthorCanSeeRequest")
    jsd_public: Optional[StrictBool] = Field(default=None, description="Whether the comment is visible in Jira Service Desk. Defaults to true when comments are created in the Jira Cloud Platform. This includes when the site doesn't use Jira Service Desk or the project isn't a Jira Service Desk project and, therefore, there is no Jira Service Desk for the issue to be visible on. To create a comment with its visibility in Jira Service Desk set to false, use the Jira Service Desk REST API [Create request comment](https://developer.atlassian.com/cloud/jira/service-desk/rest/#api-rest-servicedeskapi-request-issueIdOrKey-comment-post) operation.", alias="jsdPublic")
    properties: Optional[List[EntityProperty]] = Field(default=None, description="A list of comment properties. Optional on create and update.")
    rendered_body: Optional[StrictStr] = Field(default=None, description="The rendered version of the comment.", alias="renderedBody")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the comment.", alias="self")
    update_author: Optional[UserDetails] = Field(default=None, description="The ID of the user who updated the comment last.", alias="updateAuthor")
    updated: Optional[datetime] = Field(default=None, description="The date and time at which the comment was updated last.")
    visibility: Optional[Visibility] = Field(default=None, description="The group or role to which this comment is visible. Optional on create and update.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["author", "body", "created", "id", "jsdAuthorCanSeeRequest", "jsdPublic", "properties", "renderedBody", "self", "updateAuthor", "updated", "visibility"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Comment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "author",
            "created",
            "id",
            "jsd_author_can_see_request",
            "jsd_public",
            "rendered_body",
            "var_self",
            "update_author",
            "updated",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in properties (list)
        _items = []
        if self.properties:
            for _item_properties in self.properties:
                if _item_properties:
                    _items.append(_item_properties.to_dict())
            _dict['properties'] = _items
        # override the default output from pydantic by calling `to_dict()` of update_author
        if self.update_author:
            _dict['updateAuthor'] = self.update_author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of visibility
        if self.visibility:
            _dict['visibility'] = self.visibility.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Comment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "author": UserDetails.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "body": obj.get("body"),
            "created": obj.get("created"),
            "id": obj.get("id"),
            "jsdAuthorCanSeeRequest": obj.get("jsdAuthorCanSeeRequest"),
            "jsdPublic": obj.get("jsdPublic"),
            "properties": [EntityProperty.from_dict(_item) for _item in obj["properties"]] if obj.get("properties") is not None else None,
            "renderedBody": obj.get("renderedBody"),
            "self": obj.get("self"),
            "updateAuthor": UserDetails.from_dict(obj["updateAuthor"]) if obj.get("updateAuthor") is not None else None,
            "updated": obj.get("updated"),
            "visibility": Visibility.from_dict(obj["visibility"]) if obj.get("visibility") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


