# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.time_tracking_configuration import TimeTrackingConfiguration
from typing import Optional, Set
from typing_extensions import Self

class Configuration(BaseModel):
    """
    Details about the configuration of Jira.
    """ # noqa: E501
    attachments_enabled: Optional[StrictBool] = Field(default=None, description="Whether the ability to add attachments to issues is enabled.", alias="attachmentsEnabled")
    issue_linking_enabled: Optional[StrictBool] = Field(default=None, description="Whether the ability to link issues is enabled.", alias="issueLinkingEnabled")
    sub_tasks_enabled: Optional[StrictBool] = Field(default=None, description="Whether the ability to create subtasks for issues is enabled.", alias="subTasksEnabled")
    time_tracking_configuration: Optional[TimeTrackingConfiguration] = Field(default=None, description="The configuration of time tracking.", alias="timeTrackingConfiguration")
    time_tracking_enabled: Optional[StrictBool] = Field(default=None, description="Whether the ability to track time is enabled. This property is deprecated.", alias="timeTrackingEnabled")
    unassigned_issues_allowed: Optional[StrictBool] = Field(default=None, description="Whether the ability to create unassigned issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.", alias="unassignedIssuesAllowed")
    voting_enabled: Optional[StrictBool] = Field(default=None, description="Whether the ability for users to vote on issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.", alias="votingEnabled")
    watching_enabled: Optional[StrictBool] = Field(default=None, description="Whether the ability for users to watch issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.", alias="watchingEnabled")
    __properties: ClassVar[List[str]] = ["attachmentsEnabled", "issueLinkingEnabled", "subTasksEnabled", "timeTrackingConfiguration", "timeTrackingEnabled", "unassignedIssuesAllowed", "votingEnabled", "watchingEnabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Configuration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "attachments_enabled",
            "issue_linking_enabled",
            "sub_tasks_enabled",
            "time_tracking_configuration",
            "time_tracking_enabled",
            "unassigned_issues_allowed",
            "voting_enabled",
            "watching_enabled",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_tracking_configuration
        if self.time_tracking_configuration:
            _dict['timeTrackingConfiguration'] = self.time_tracking_configuration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Configuration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attachmentsEnabled": obj.get("attachmentsEnabled"),
            "issueLinkingEnabled": obj.get("issueLinkingEnabled"),
            "subTasksEnabled": obj.get("subTasksEnabled"),
            "timeTrackingConfiguration": TimeTrackingConfiguration.from_dict(obj["timeTrackingConfiguration"]) if obj.get("timeTrackingConfiguration") is not None else None,
            "timeTrackingEnabled": obj.get("timeTrackingEnabled"),
            "unassignedIssuesAllowed": obj.get("unassignedIssuesAllowed"),
            "votingEnabled": obj.get("votingEnabled"),
            "watchingEnabled": obj.get("watchingEnabled")
        })
        return _obj


