# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ConnectCustomFieldValue(BaseModel):
    """
    A list of custom field details.
    """ # noqa: E501
    type: StrictStr = Field(description="The type of custom field.", alias="_type")
    field_id: StrictInt = Field(description="The custom field ID.", alias="fieldID")
    issue_id: StrictInt = Field(description="The issue ID.", alias="issueID")
    number: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The value of number type custom field when `_type` is `NumberIssueField`.")
    option_id: Optional[StrictStr] = Field(default=None, description="The value of single select and multiselect custom field type when `_type` is `SingleSelectIssueField` or `MultiSelectIssueField`.", alias="optionID")
    rich_text: Optional[StrictStr] = Field(default=None, description="The value of richText type custom field when `_type` is `RichTextIssueField`.", alias="richText")
    string: Optional[StrictStr] = Field(default=None, description="The value of string type custom field when `_type` is `StringIssueField`.")
    text: Optional[StrictStr] = Field(default=None, description="The value of of text custom field type when `_type` is `TextIssueField`.")
    __properties: ClassVar[List[str]] = ["_type", "fieldID", "issueID", "number", "optionID", "richText", "string", "text"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['StringIssueField', 'NumberIssueField', 'RichTextIssueField', 'SingleSelectIssueField', 'MultiSelectIssueField', 'TextIssueField']):
            raise ValueError("must be one of enum values ('StringIssueField', 'NumberIssueField', 'RichTextIssueField', 'SingleSelectIssueField', 'MultiSelectIssueField', 'TextIssueField')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConnectCustomFieldValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConnectCustomFieldValue from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_type": obj.get("_type"),
            "fieldID": obj.get("fieldID"),
            "issueID": obj.get("issueID"),
            "number": obj.get("number"),
            "optionID": obj.get("optionID"),
            "richText": obj.get("richText"),
            "string": obj.get("string"),
            "text": obj.get("text")
        })
        return _obj


