# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreatePlanOnlyTeamRequest(BaseModel):
    """
    CreatePlanOnlyTeamRequest
    """ # noqa: E501
    capacity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The capacity for the plan-only team.")
    issue_source_id: Optional[StrictInt] = Field(default=None, description="The ID of the issue source for the plan-only team.", alias="issueSourceId")
    member_account_ids: Optional[List[StrictStr]] = Field(default=None, description="The account IDs of the plan-only team members.", alias="memberAccountIds")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=255)] = Field(description="The plan-only team name.")
    planning_style: StrictStr = Field(description="The planning style for the plan-only team. This must be \"Scrum\" or \"Kanban\".", alias="planningStyle")
    sprint_length: Optional[StrictInt] = Field(default=None, description="The sprint length for the plan-only team.", alias="sprintLength")
    __properties: ClassVar[List[str]] = ["capacity", "issueSourceId", "memberAccountIds", "name", "planningStyle", "sprintLength"]

    @field_validator('planning_style')
    def planning_style_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Scrum', 'Kanban']):
            raise ValueError("must be one of enum values ('Scrum', 'Kanban')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePlanOnlyTeamRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePlanOnlyTeamRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "capacity": obj.get("capacity"),
            "issueSourceId": obj.get("issueSourceId"),
            "memberAccountIds": obj.get("memberAccountIds"),
            "name": obj.get("name"),
            "planningStyle": obj.get("planningStyle"),
            "sprintLength": obj.get("sprintLength")
        })
        return _obj


