# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud.models.create_cross_project_release_request import CreateCrossProjectReleaseRequest
from devopso.clients.jira_cloud.models.create_custom_field_request import CreateCustomFieldRequest
from devopso.clients.jira_cloud.models.create_exclusion_rules_request import CreateExclusionRulesRequest
from devopso.clients.jira_cloud.models.create_issue_source_request import CreateIssueSourceRequest
from devopso.clients.jira_cloud.models.create_permission_request import CreatePermissionRequest
from devopso.clients.jira_cloud.models.create_scheduling_request import CreateSchedulingRequest
from typing import Optional, Set
from typing_extensions import Self

class CreatePlanRequest(BaseModel):
    """
    CreatePlanRequest
    """ # noqa: E501
    cross_project_releases: Optional[List[CreateCrossProjectReleaseRequest]] = Field(default=None, description="The cross-project releases to include in the plan.", alias="crossProjectReleases")
    custom_fields: Optional[List[CreateCustomFieldRequest]] = Field(default=None, description="The custom fields for the plan.", alias="customFields")
    exclusion_rules: Optional[CreateExclusionRulesRequest] = Field(default=None, description="The exclusion rules for the plan.", alias="exclusionRules")
    issue_sources: List[CreateIssueSourceRequest] = Field(description="The issue sources to include in the plan.", alias="issueSources")
    lead_account_id: Optional[StrictStr] = Field(default=None, description="The account ID of the plan lead.", alias="leadAccountId")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=255)] = Field(description="The plan name.")
    permissions: Optional[List[CreatePermissionRequest]] = Field(default=None, description="The permissions for the plan.")
    scheduling: CreateSchedulingRequest = Field(description="The scheduling settings for the plan.")
    __properties: ClassVar[List[str]] = ["crossProjectReleases", "customFields", "exclusionRules", "issueSources", "leadAccountId", "name", "permissions", "scheduling"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePlanRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in cross_project_releases (list)
        _items = []
        if self.cross_project_releases:
            for _item_cross_project_releases in self.cross_project_releases:
                if _item_cross_project_releases:
                    _items.append(_item_cross_project_releases.to_dict())
            _dict['crossProjectReleases'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item_custom_fields in self.custom_fields:
                if _item_custom_fields:
                    _items.append(_item_custom_fields.to_dict())
            _dict['customFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of exclusion_rules
        if self.exclusion_rules:
            _dict['exclusionRules'] = self.exclusion_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in issue_sources (list)
        _items = []
        if self.issue_sources:
            for _item_issue_sources in self.issue_sources:
                if _item_issue_sources:
                    _items.append(_item_issue_sources.to_dict())
            _dict['issueSources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item_permissions in self.permissions:
                if _item_permissions:
                    _items.append(_item_permissions.to_dict())
            _dict['permissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of scheduling
        if self.scheduling:
            _dict['scheduling'] = self.scheduling.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePlanRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "crossProjectReleases": [CreateCrossProjectReleaseRequest.from_dict(_item) for _item in obj["crossProjectReleases"]] if obj.get("crossProjectReleases") is not None else None,
            "customFields": [CreateCustomFieldRequest.from_dict(_item) for _item in obj["customFields"]] if obj.get("customFields") is not None else None,
            "exclusionRules": CreateExclusionRulesRequest.from_dict(obj["exclusionRules"]) if obj.get("exclusionRules") is not None else None,
            "issueSources": [CreateIssueSourceRequest.from_dict(_item) for _item in obj["issueSources"]] if obj.get("issueSources") is not None else None,
            "leadAccountId": obj.get("leadAccountId"),
            "name": obj.get("name"),
            "permissions": [CreatePermissionRequest.from_dict(_item) for _item in obj["permissions"]] if obj.get("permissions") is not None else None,
            "scheduling": CreateSchedulingRequest.from_dict(obj["scheduling"]) if obj.get("scheduling") is not None else None
        })
        return _obj


