# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud.models.priority_mapping import PriorityMapping
from typing import Optional, Set
from typing_extensions import Self

class CreatePrioritySchemeDetails(BaseModel):
    """
    Details of a new priority scheme
    """ # noqa: E501
    default_priority_id: StrictInt = Field(description="The ID of the default priority for the priority scheme.", alias="defaultPriorityId")
    description: Optional[Annotated[str, Field(strict=True, max_length=4000)]] = Field(default=None, description="The description of the priority scheme.")
    mappings: Optional[PriorityMapping] = Field(default=None, description="Instructions to migrate the priorities of issues.  `in` mappings are used to migrate the priorities of issues to priorities used within the priority scheme.  `out` mappings are used to migrate the priorities of issues to priorities not used within the priority scheme.   *  When **priorities** are **added** to the new priority scheme, no mapping needs to be provided as the new priorities are not used by any issues.  *  When **priorities** are **removed** from the new priority scheme, no mapping needs to be provided as the removed priorities are not used by any issues.  *  When **projects** are **added** to the priority scheme, the priorities of issues in those projects might need to be migrated to new priorities used by the priority scheme. This can occur when the current scheme does not use all the priorities in the project(s)' priority scheme(s).           *  An `in` mapping must be provided for each of these priorities.  *  When **projects** are **removed** from the priority scheme, no mapping needs to be provided as the removed projects are not using the priorities of the new priority scheme.  For more information on `in` and `out` mappings, see the child properties documentation for the `PriorityMapping` object below.")
    name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The name of the priority scheme. Must be unique.")
    priority_ids: List[Annotated[int, Field(strict=True)]] = Field(description="The IDs of priorities in the scheme.", alias="priorityIds")
    project_ids: Optional[List[StrictInt]] = Field(default=None, description="The IDs of projects that will use the priority scheme.", alias="projectIds")
    __properties: ClassVar[List[str]] = ["defaultPriorityId", "description", "mappings", "name", "priorityIds", "projectIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePrioritySchemeDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mappings
        if self.mappings:
            _dict['mappings'] = self.mappings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePrioritySchemeDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultPriorityId": obj.get("defaultPriorityId"),
            "description": obj.get("description"),
            "mappings": PriorityMapping.from_dict(obj["mappings"]) if obj.get("mappings") is not None else None,
            "name": obj.get("name"),
            "priorityIds": obj.get("priorityIds"),
            "projectIds": obj.get("projectIds")
        })
        return _obj


