# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreateProjectDetails(BaseModel):
    """
    Details about the project.
    """ # noqa: E501
    assignee_type: Optional[StrictStr] = Field(default=None, description="The default assignee when creating issues for this project.", alias="assigneeType")
    avatar_id: Optional[StrictInt] = Field(default=None, description="An integer value for the project's avatar.", alias="avatarId")
    category_id: Optional[StrictInt] = Field(default=None, description="The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation.", alias="categoryId")
    description: Optional[StrictStr] = Field(default=None, description="A brief description of the project.")
    field_configuration_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the field configuration scheme for the project. Use the [Get all field configuration schemes](#api-rest-api-3-fieldconfigurationscheme-get) operation to get a list of field configuration scheme IDs. If you specify the field configuration scheme you cannot specify the project template key.", alias="fieldConfigurationScheme")
    issue_security_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) resource to get all issue security scheme IDs.", alias="issueSecurityScheme")
    issue_type_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the issue type scheme for the project. Use the [Get all issue type schemes](#api-rest-api-3-issuetypescheme-get) operation to get a list of issue type scheme IDs. If you specify the issue type scheme you cannot specify the project template key.", alias="issueTypeScheme")
    issue_type_screen_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the issue type screen scheme for the project. Use the [Get all issue type screen schemes](#api-rest-api-3-issuetypescreenscheme-get) operation to get a list of issue type screen scheme IDs. If you specify the issue type screen scheme you cannot specify the project template key.", alias="issueTypeScreenScheme")
    key: StrictStr = Field(description="Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.")
    lead: Optional[StrictStr] = Field(default=None, description="This parameter is deprecated because of privacy changes. Use `leadAccountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `leadAccountId`.")
    lead_account_id: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(default=None, description="The account ID of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `lead`.", alias="leadAccountId")
    name: StrictStr = Field(description="The name of the project.")
    notification_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-3-notificationscheme-get) resource to get a list of notification scheme IDs.", alias="notificationScheme")
    permission_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to see a list of all permission scheme IDs.", alias="permissionScheme")
    project_template_key: Optional[StrictStr] = Field(default=None, description="A predefined configuration for a project. The type of the `projectTemplateKey` must match with the type of the `projectTypeKey`.", alias="projectTemplateKey")
    project_type_key: Optional[StrictStr] = Field(default=None, description="The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes), which defines the application-specific feature set. If you don't specify the project template you have to specify the project type.", alias="projectTypeKey")
    url: Optional[StrictStr] = Field(default=None, description="A link to information about this project, such as project documentation")
    workflow_scheme: Optional[StrictInt] = Field(default=None, description="The ID of the workflow scheme for the project. Use the [Get all workflow schemes](#api-rest-api-3-workflowscheme-get) operation to get a list of workflow scheme IDs. If you specify the workflow scheme you cannot specify the project template key.", alias="workflowScheme")
    __properties: ClassVar[List[str]] = ["assigneeType", "avatarId", "categoryId", "description", "fieldConfigurationScheme", "issueSecurityScheme", "issueTypeScheme", "issueTypeScreenScheme", "key", "lead", "leadAccountId", "name", "notificationScheme", "permissionScheme", "projectTemplateKey", "projectTypeKey", "url", "workflowScheme"]

    @field_validator('assignee_type')
    def assignee_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PROJECT_LEAD', 'UNASSIGNED']):
            raise ValueError("must be one of enum values ('PROJECT_LEAD', 'UNASSIGNED')")
        return value

    @field_validator('project_template_key')
    def project_template_key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['com.pyxis.greenhopper.jira:gh-simplified-agility-kanban', 'com.pyxis.greenhopper.jira:gh-simplified-agility-scrum', 'com.pyxis.greenhopper.jira:gh-simplified-basic', 'com.pyxis.greenhopper.jira:gh-simplified-kanban-classic', 'com.pyxis.greenhopper.jira:gh-simplified-scrum-classic', 'com.pyxis.greenhopper.jira:gh-cross-team-template', 'com.pyxis.greenhopper.jira:gh-cross-team-planning-template', 'com.atlassian.servicedesk:simplified-it-service-management', 'com.atlassian.servicedesk:simplified-it-service-management-basic', 'com.atlassian.servicedesk:simplified-it-service-management-operations', 'com.atlassian.servicedesk:simplified-general-service-desk', 'com.atlassian.servicedesk:simplified-general-service-desk-it', 'com.atlassian.servicedesk:simplified-general-service-desk-business', 'com.atlassian.servicedesk:simplified-internal-service-desk', 'com.atlassian.servicedesk:simplified-external-service-desk', 'com.atlassian.servicedesk:simplified-hr-service-desk', 'com.atlassian.servicedesk:simplified-facilities-service-desk', 'com.atlassian.servicedesk:simplified-legal-service-desk', 'com.atlassian.servicedesk:simplified-marketing-service-desk', 'com.atlassian.servicedesk:simplified-finance-service-desk', 'com.atlassian.servicedesk:simplified-analytics-service-desk', 'com.atlassian.servicedesk:simplified-design-service-desk', 'com.atlassian.servicedesk:simplified-sales-service-desk', 'com.atlassian.servicedesk:simplified-halp-service-desk', 'com.atlassian.servicedesk:simplified-blank-project-it', 'com.atlassian.servicedesk:simplified-blank-project-business', 'com.atlassian.servicedesk:next-gen-it-service-desk', 'com.atlassian.servicedesk:next-gen-hr-service-desk', 'com.atlassian.servicedesk:next-gen-legal-service-desk', 'com.atlassian.servicedesk:next-gen-marketing-service-desk', 'com.atlassian.servicedesk:next-gen-facilities-service-desk', 'com.atlassian.servicedesk:next-gen-general-service-desk', 'com.atlassian.servicedesk:next-gen-general-it-service-desk', 'com.atlassian.servicedesk:next-gen-general-business-service-desk', 'com.atlassian.servicedesk:next-gen-analytics-service-desk', 'com.atlassian.servicedesk:next-gen-finance-service-desk', 'com.atlassian.servicedesk:next-gen-design-service-desk', 'com.atlassian.servicedesk:next-gen-sales-service-desk', 'com.atlassian.jira-core-project-templates:jira-core-simplified-content-management', 'com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval', 'com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking', 'com.atlassian.jira-core-project-templates:jira-core-simplified-process-control', 'com.atlassian.jira-core-project-templates:jira-core-simplified-procurement', 'com.atlassian.jira-core-project-templates:jira-core-simplified-project-management', 'com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment', 'com.atlassian.jira-core-project-templates:jira-core-simplified-task-']):
            raise ValueError("must be one of enum values ('com.pyxis.greenhopper.jira:gh-simplified-agility-kanban', 'com.pyxis.greenhopper.jira:gh-simplified-agility-scrum', 'com.pyxis.greenhopper.jira:gh-simplified-basic', 'com.pyxis.greenhopper.jira:gh-simplified-kanban-classic', 'com.pyxis.greenhopper.jira:gh-simplified-scrum-classic', 'com.pyxis.greenhopper.jira:gh-cross-team-template', 'com.pyxis.greenhopper.jira:gh-cross-team-planning-template', 'com.atlassian.servicedesk:simplified-it-service-management', 'com.atlassian.servicedesk:simplified-it-service-management-basic', 'com.atlassian.servicedesk:simplified-it-service-management-operations', 'com.atlassian.servicedesk:simplified-general-service-desk', 'com.atlassian.servicedesk:simplified-general-service-desk-it', 'com.atlassian.servicedesk:simplified-general-service-desk-business', 'com.atlassian.servicedesk:simplified-internal-service-desk', 'com.atlassian.servicedesk:simplified-external-service-desk', 'com.atlassian.servicedesk:simplified-hr-service-desk', 'com.atlassian.servicedesk:simplified-facilities-service-desk', 'com.atlassian.servicedesk:simplified-legal-service-desk', 'com.atlassian.servicedesk:simplified-marketing-service-desk', 'com.atlassian.servicedesk:simplified-finance-service-desk', 'com.atlassian.servicedesk:simplified-analytics-service-desk', 'com.atlassian.servicedesk:simplified-design-service-desk', 'com.atlassian.servicedesk:simplified-sales-service-desk', 'com.atlassian.servicedesk:simplified-halp-service-desk', 'com.atlassian.servicedesk:simplified-blank-project-it', 'com.atlassian.servicedesk:simplified-blank-project-business', 'com.atlassian.servicedesk:next-gen-it-service-desk', 'com.atlassian.servicedesk:next-gen-hr-service-desk', 'com.atlassian.servicedesk:next-gen-legal-service-desk', 'com.atlassian.servicedesk:next-gen-marketing-service-desk', 'com.atlassian.servicedesk:next-gen-facilities-service-desk', 'com.atlassian.servicedesk:next-gen-general-service-desk', 'com.atlassian.servicedesk:next-gen-general-it-service-desk', 'com.atlassian.servicedesk:next-gen-general-business-service-desk', 'com.atlassian.servicedesk:next-gen-analytics-service-desk', 'com.atlassian.servicedesk:next-gen-finance-service-desk', 'com.atlassian.servicedesk:next-gen-design-service-desk', 'com.atlassian.servicedesk:next-gen-sales-service-desk', 'com.atlassian.jira-core-project-templates:jira-core-simplified-content-management', 'com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval', 'com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking', 'com.atlassian.jira-core-project-templates:jira-core-simplified-process-control', 'com.atlassian.jira-core-project-templates:jira-core-simplified-procurement', 'com.atlassian.jira-core-project-templates:jira-core-simplified-project-management', 'com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment', 'com.atlassian.jira-core-project-templates:jira-core-simplified-task-')")
        return value

    @field_validator('project_type_key')
    def project_type_key_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['software', 'service_desk', 'business']):
            raise ValueError("must be one of enum values ('software', 'service_desk', 'business')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateProjectDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateProjectDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assigneeType": obj.get("assigneeType"),
            "avatarId": obj.get("avatarId"),
            "categoryId": obj.get("categoryId"),
            "description": obj.get("description"),
            "fieldConfigurationScheme": obj.get("fieldConfigurationScheme"),
            "issueSecurityScheme": obj.get("issueSecurityScheme"),
            "issueTypeScheme": obj.get("issueTypeScheme"),
            "issueTypeScreenScheme": obj.get("issueTypeScreenScheme"),
            "key": obj.get("key"),
            "lead": obj.get("lead"),
            "leadAccountId": obj.get("leadAccountId"),
            "name": obj.get("name"),
            "notificationScheme": obj.get("notificationScheme"),
            "permissionScheme": obj.get("permissionScheme"),
            "projectTemplateKey": obj.get("projectTemplateKey"),
            "projectTypeKey": obj.get("projectTypeKey"),
            "url": obj.get("url"),
            "workflowScheme": obj.get("workflowScheme")
        })
        return _obj


