# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.ui_modification_context_details import UiModificationContextDetails
from typing import Optional, Set
from typing_extensions import Self

class CreateUiModificationDetails(BaseModel):
    """
    The details of a UI modification.
    """ # noqa: E501
    contexts: Optional[List[UiModificationContextDetails]] = Field(default=None, description="List of contexts of the UI modification. The maximum number of contexts is 1000.")
    data: Optional[StrictStr] = Field(default=None, description="The data of the UI modification. The maximum size of the data is 50000 characters.")
    description: Optional[StrictStr] = Field(default=None, description="The description of the UI modification. The maximum length is 255 characters.")
    name: StrictStr = Field(description="The name of the UI modification. The maximum length is 255 characters.")
    __properties: ClassVar[List[str]] = ["contexts", "data", "description", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateUiModificationDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in contexts (list)
        _items = []
        if self.contexts:
            for _item_contexts in self.contexts:
                if _item_contexts:
                    _items.append(_item_contexts.to_dict())
            _dict['contexts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateUiModificationDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "contexts": [UiModificationContextDetails.from_dict(_item) for _item in obj["contexts"]] if obj.get("contexts") is not None else None,
            "data": obj.get("data"),
            "description": obj.get("description"),
            "name": obj.get("name")
        })
        return _obj


