# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.create_workflow_transition_rules_details import CreateWorkflowTransitionRulesDetails
from devopso.clients.jira_cloud.models.create_workflow_transition_screen_details import CreateWorkflowTransitionScreenDetails
from typing import Optional, Set
from typing_extensions import Self

class CreateWorkflowTransitionDetails(BaseModel):
    """
    The details of a workflow transition.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the transition. The maximum length is 1000 characters.")
    var_from: Optional[List[StrictStr]] = Field(default=None, description="The statuses the transition can start from.", alias="from")
    name: StrictStr = Field(description="The name of the transition. The maximum length is 60 characters.")
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="The properties of the transition.")
    rules: Optional[CreateWorkflowTransitionRulesDetails] = Field(default=None, description="The rules of the transition.")
    screen: Optional[CreateWorkflowTransitionScreenDetails] = Field(default=None, description="The screen of the transition.")
    to: StrictStr = Field(description="The status the transition goes to.")
    type: StrictStr = Field(description="The type of the transition.")
    __properties: ClassVar[List[str]] = ["description", "from", "name", "properties", "rules", "screen", "to", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['global', 'initial', 'directed']):
            raise ValueError("must be one of enum values ('global', 'initial', 'directed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateWorkflowTransitionDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rules
        if self.rules:
            _dict['rules'] = self.rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of screen
        if self.screen:
            _dict['screen'] = self.screen.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateWorkflowTransitionDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "from": obj.get("from"),
            "name": obj.get("name"),
            "properties": obj.get("properties"),
            "rules": CreateWorkflowTransitionRulesDetails.from_dict(obj["rules"]) if obj.get("rules") is not None else None,
            "screen": CreateWorkflowTransitionScreenDetails.from_dict(obj["screen"]) if obj.get("screen") is not None else None,
            "to": obj.get("to"),
            "type": obj.get("type")
        })
        return _obj


