# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.create_workflow_condition import CreateWorkflowCondition
from devopso.clients.jira_cloud.models.create_workflow_transition_rule import CreateWorkflowTransitionRule
from typing import Optional, Set
from typing_extensions import Self

class CreateWorkflowTransitionRulesDetails(BaseModel):
    """
    The details of a workflow transition rules.
    """ # noqa: E501
    conditions: Optional[CreateWorkflowCondition] = Field(default=None, description="The workflow conditions.")
    post_functions: Optional[List[CreateWorkflowTransitionRule]] = Field(default=None, description="The workflow post functions.  **Note:** The default post functions are always added to the *initial* transition, as in:      \"postFunctions\": [         {             \"type\": \"IssueCreateFunction\"         },         {             \"type\": \"IssueReindexFunction\"         },         {             \"type\": \"FireIssueEventFunction\",             \"configuration\": {                 \"event\": {                     \"id\": \"1\",                     \"name\": \"issue_created\"                 }             }         }     ]  **Note:** The default post functions are always added to the *global* and *directed* transitions, as in:      \"postFunctions\": [         {             \"type\": \"UpdateIssueStatusFunction\"         },         {             \"type\": \"CreateCommentFunction\"         },         {             \"type\": \"GenerateChangeHistoryFunction\"         },         {             \"type\": \"IssueReindexFunction\"         },         {             \"type\": \"FireIssueEventFunction\",             \"configuration\": {                 \"event\": {                     \"id\": \"13\",                     \"name\": \"issue_generic\"                 }             }         }     ]", alias="postFunctions")
    validators: Optional[List[CreateWorkflowTransitionRule]] = Field(default=None, description="The workflow validators.  **Note:** The default permission validator is always added to the *initial* transition, as in:      \"validators\": [         {             \"type\": \"PermissionValidator\",             \"configuration\": {                 \"permissionKey\": \"CREATE_ISSUES\"             }         }     ]")
    __properties: ClassVar[List[str]] = ["conditions", "postFunctions", "validators"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateWorkflowTransitionRulesDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of conditions
        if self.conditions:
            _dict['conditions'] = self.conditions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in post_functions (list)
        _items = []
        if self.post_functions:
            for _item_post_functions in self.post_functions:
                if _item_post_functions:
                    _items.append(_item_post_functions.to_dict())
            _dict['postFunctions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in validators (list)
        _items = []
        if self.validators:
            for _item_validators in self.validators:
                if _item_validators:
                    _items.append(_item_validators.to_dict())
            _dict['validators'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateWorkflowTransitionRulesDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "conditions": CreateWorkflowCondition.from_dict(obj["conditions"]) if obj.get("conditions") is not None else None,
            "postFunctions": [CreateWorkflowTransitionRule.from_dict(_item) for _item in obj["postFunctions"]] if obj.get("postFunctions") is not None else None,
            "validators": [CreateWorkflowTransitionRule.from_dict(_item) for _item in obj["validators"]] if obj.get("validators") is not None else None
        })
        return _obj


