# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from devopso.clients.jira_cloud.models.issue_context_variable import IssueContextVariable
from devopso.clients.jira_cloud.models.json_context_variable import JsonContextVariable
from devopso.clients.jira_cloud.models.user_context_variable import UserContextVariable
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

CUSTOMCONTEXTVARIABLE_ONE_OF_SCHEMAS = ["IssueContextVariable", "JsonContextVariable", "UserContextVariable"]

class CustomContextVariable(BaseModel):
    """
    CustomContextVariable
    """
    # data type: UserContextVariable
    oneof_schema_1_validator: Optional[UserContextVariable] = None
    # data type: IssueContextVariable
    oneof_schema_2_validator: Optional[IssueContextVariable] = None
    # data type: JsonContextVariable
    oneof_schema_3_validator: Optional[JsonContextVariable] = None
    actual_instance: Optional[Union[IssueContextVariable, JsonContextVariable, UserContextVariable]] = None
    one_of_schemas: Set[str] = { "IssueContextVariable", "JsonContextVariable", "UserContextVariable" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = CustomContextVariable.model_construct()
        error_messages = []
        match = 0
        # validate data type: UserContextVariable
        if not isinstance(v, UserContextVariable):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UserContextVariable`")
        else:
            match += 1
        # validate data type: IssueContextVariable
        if not isinstance(v, IssueContextVariable):
            error_messages.append(f"Error! Input type `{type(v)}` is not `IssueContextVariable`")
        else:
            match += 1
        # validate data type: JsonContextVariable
        if not isinstance(v, JsonContextVariable):
            error_messages.append(f"Error! Input type `{type(v)}` is not `JsonContextVariable`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in CustomContextVariable with oneOf schemas: IssueContextVariable, JsonContextVariable, UserContextVariable. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in CustomContextVariable with oneOf schemas: IssueContextVariable, JsonContextVariable, UserContextVariable. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into UserContextVariable
        try:
            instance.actual_instance = UserContextVariable.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into IssueContextVariable
        try:
            instance.actual_instance = IssueContextVariable.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into JsonContextVariable
        try:
            instance.actual_instance = JsonContextVariable.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into CustomContextVariable with oneOf schemas: IssueContextVariable, JsonContextVariable, UserContextVariable. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into CustomContextVariable with oneOf schemas: IssueContextVariable, JsonContextVariable, UserContextVariable. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], IssueContextVariable, JsonContextVariable, UserContextVariable]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


