# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class CustomFieldPayload(BaseModel):
    """
    Defines the payload for the custom field definitions. See https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-issue-fields/\\#api-rest-api-3-field-post
    """ # noqa: E501
    cf_type: Optional[StrictStr] = Field(default=None, description="The type of the custom field", alias="cfType")
    description: Optional[StrictStr] = Field(default=None, description="The description of the custom field")
    name: Optional[StrictStr] = Field(default=None, description="The name of the custom field")
    on_conflict: Optional[StrictStr] = Field(default=None, description="The strategy to use when there is a conflict with an existing custom field. FAIL - Fail execution, this always needs to be unique; USE - Use the existing entity and ignore new entity parameters", alias="onConflict")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    scope: Optional[StrictStr] = Field(default=None, description="Allows an overwrite to declare the new Custom Field to be created as a GLOBAL-scoped field. Leave this as empty or null to use the project's default scope.")
    searcher_key: Optional[StrictStr] = Field(default=None, description="The searcher key of the custom field", alias="searcherKey")
    __properties: ClassVar[List[str]] = ["cfType", "description", "name", "onConflict", "pcri", "scope", "searcherKey"]

    @field_validator('on_conflict')
    def on_conflict_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FAIL', 'USE', 'NEW']):
            raise ValueError("must be one of enum values ('FAIL', 'USE', 'NEW')")
        return value

    @field_validator('scope')
    def scope_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['GLOBAL', 'TEMPLATE', 'PROJECT']):
            raise ValueError("must be one of enum values ('GLOBAL', 'TEMPLATE', 'PROJECT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomFieldPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomFieldPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cfType": obj.get("cfType"),
            "description": obj.get("description"),
            "name": obj.get("name"),
            "onConflict": obj.get("onConflict"),
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None,
            "scope": obj.get("scope"),
            "searcherKey": obj.get("searcherKey")
        })
        return _obj


