# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.boards_payload import BoardsPayload
from devopso.clients.jira_cloud.models.field_capability_payload import FieldCapabilityPayload
from devopso.clients.jira_cloud.models.issue_type_project_create_payload import IssueTypeProjectCreatePayload
from devopso.clients.jira_cloud.models.notification_scheme_payload import NotificationSchemePayload
from devopso.clients.jira_cloud.models.permission_payload_dto import PermissionPayloadDTO
from devopso.clients.jira_cloud.models.project_payload import ProjectPayload
from devopso.clients.jira_cloud.models.roles_capability_payload import RolesCapabilityPayload
from devopso.clients.jira_cloud.models.scope_payload import ScopePayload
from devopso.clients.jira_cloud.models.security_scheme_payload import SecuritySchemePayload
from devopso.clients.jira_cloud.models.workflow_capability_payload import WorkflowCapabilityPayload
from typing import Optional, Set
from typing_extensions import Self

class CustomTemplateRequestDTO(BaseModel):
    """
    The specific request object for creating a project with template.
    """ # noqa: E501
    boards: Optional[BoardsPayload] = None
    var_field: Optional[FieldCapabilityPayload] = Field(default=None, alias="field")
    issue_type: Optional[IssueTypeProjectCreatePayload] = Field(default=None, alias="issueType")
    notification: Optional[NotificationSchemePayload] = None
    permission_scheme: Optional[PermissionPayloadDTO] = Field(default=None, alias="permissionScheme")
    project: Optional[ProjectPayload] = None
    role: Optional[RolesCapabilityPayload] = None
    scope: Optional[ScopePayload] = None
    security: Optional[SecuritySchemePayload] = None
    workflow: Optional[WorkflowCapabilityPayload] = None
    __properties: ClassVar[List[str]] = ["boards", "field", "issueType", "notification", "permissionScheme", "project", "role", "scope", "security", "workflow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomTemplateRequestDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of boards
        if self.boards:
            _dict['boards'] = self.boards.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_field
        if self.var_field:
            _dict['field'] = self.var_field.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issue_type
        if self.issue_type:
            _dict['issueType'] = self.issue_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notification
        if self.notification:
            _dict['notification'] = self.notification.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permission_scheme
        if self.permission_scheme:
            _dict['permissionScheme'] = self.permission_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of role
        if self.role:
            _dict['role'] = self.role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of scope
        if self.scope:
            _dict['scope'] = self.scope.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow
        if self.workflow:
            _dict['workflow'] = self.workflow.to_dict()
        # set to None if boards (nullable) is None
        # and model_fields_set contains the field
        if self.boards is None and "boards" in self.model_fields_set:
            _dict['boards'] = None

        # set to None if var_field (nullable) is None
        # and model_fields_set contains the field
        if self.var_field is None and "var_field" in self.model_fields_set:
            _dict['field'] = None

        # set to None if issue_type (nullable) is None
        # and model_fields_set contains the field
        if self.issue_type is None and "issue_type" in self.model_fields_set:
            _dict['issueType'] = None

        # set to None if notification (nullable) is None
        # and model_fields_set contains the field
        if self.notification is None and "notification" in self.model_fields_set:
            _dict['notification'] = None

        # set to None if permission_scheme (nullable) is None
        # and model_fields_set contains the field
        if self.permission_scheme is None and "permission_scheme" in self.model_fields_set:
            _dict['permissionScheme'] = None

        # set to None if role (nullable) is None
        # and model_fields_set contains the field
        if self.role is None and "role" in self.model_fields_set:
            _dict['role'] = None

        # set to None if scope (nullable) is None
        # and model_fields_set contains the field
        if self.scope is None and "scope" in self.model_fields_set:
            _dict['scope'] = None

        # set to None if security (nullable) is None
        # and model_fields_set contains the field
        if self.security is None and "security" in self.model_fields_set:
            _dict['security'] = None

        # set to None if workflow (nullable) is None
        # and model_fields_set contains the field
        if self.workflow is None and "workflow" in self.model_fields_set:
            _dict['workflow'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomTemplateRequestDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "boards": BoardsPayload.from_dict(obj["boards"]) if obj.get("boards") is not None else None,
            "field": FieldCapabilityPayload.from_dict(obj["field"]) if obj.get("field") is not None else None,
            "issueType": IssueTypeProjectCreatePayload.from_dict(obj["issueType"]) if obj.get("issueType") is not None else None,
            "notification": NotificationSchemePayload.from_dict(obj["notification"]) if obj.get("notification") is not None else None,
            "permissionScheme": PermissionPayloadDTO.from_dict(obj["permissionScheme"]) if obj.get("permissionScheme") is not None else None,
            "project": ProjectPayload.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "role": RolesCapabilityPayload.from_dict(obj["role"]) if obj.get("role") is not None else None,
            "scope": ScopePayload.from_dict(obj["scope"]) if obj.get("scope") is not None else None,
            "security": SecuritySchemePayload.from_dict(obj["security"]) if obj.get("security") is not None else None,
            "workflow": WorkflowCapabilityPayload.from_dict(obj["workflow"]) if obj.get("workflow") is not None else None
        })
        return _obj


