# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CustomTemplatesProjectDetails(BaseModel):
    """
    Project Details
    """ # noqa: E501
    access_level: Optional[StrictStr] = Field(default=None, description="The access level of the project. Only used by team-managed project", alias="accessLevel")
    additional_properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="Additional properties of the project", alias="additionalProperties")
    assignee_type: Optional[StrictStr] = Field(default=None, description="The default assignee when creating issues in the project", alias="assigneeType")
    avatar_id: Optional[StrictInt] = Field(default=None, description="The ID of the project's avatar. Use the \\[Get project avatars\\](\\#api-rest-api-3-project-projectIdOrKey-avatar-get) operation to list the available avatars in a project.", alias="avatarId")
    category_id: Optional[StrictInt] = Field(default=None, description="The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation.", alias="categoryId")
    description: Optional[StrictStr] = Field(default=None, description="Brief description of the project")
    enable_components: Optional[StrictBool] = Field(default=False, description="Whether components are enabled for the project. Only used by company-managed project", alias="enableComponents")
    key: Optional[StrictStr] = Field(default=None, description="Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.")
    language: Optional[StrictStr] = Field(default=None, description="The default language for the project")
    lead_account_id: Optional[StrictStr] = Field(default=None, description="The account ID of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `lead`.", alias="leadAccountId")
    name: Optional[StrictStr] = Field(default=None, description="Name of the project")
    url: Optional[StrictStr] = Field(default=None, description="A link to information about this project, such as project documentation")
    __properties: ClassVar[List[str]] = ["accessLevel", "additionalProperties", "assigneeType", "avatarId", "categoryId", "description", "enableComponents", "key", "language", "leadAccountId", "name", "url"]

    @field_validator('access_level')
    def access_level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['open', 'limited', 'private', 'free']):
            raise ValueError("must be one of enum values ('open', 'limited', 'private', 'free')")
        return value

    @field_validator('assignee_type')
    def assignee_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PROJECT_DEFAULT', 'COMPONENT_LEAD', 'PROJECT_LEAD', 'UNASSIGNED']):
            raise ValueError("must be one of enum values ('PROJECT_DEFAULT', 'COMPONENT_LEAD', 'PROJECT_LEAD', 'UNASSIGNED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomTemplatesProjectDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomTemplatesProjectDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accessLevel": obj.get("accessLevel"),
            "additionalProperties": obj.get("additionalProperties"),
            "assigneeType": obj.get("assigneeType"),
            "avatarId": obj.get("avatarId"),
            "categoryId": obj.get("categoryId"),
            "description": obj.get("description"),
            "enableComponents": obj.get("enableComponents") if obj.get("enableComponents") is not None else False,
            "key": obj.get("key"),
            "language": obj.get("language"),
            "leadAccountId": obj.get("leadAccountId"),
            "name": obj.get("name"),
            "url": obj.get("url")
        })
        return _obj


