# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.share_permission import SharePermission
from devopso.clients.jira_cloud.models.user_bean import UserBean
from typing import Optional, Set
from typing_extensions import Self

class Dashboard(BaseModel):
    """
    Details of a dashboard.
    """ # noqa: E501
    automatic_refresh_ms: Optional[StrictInt] = Field(default=None, description="The automatic refresh interval for the dashboard in milliseconds.", alias="automaticRefreshMs")
    description: Optional[StrictStr] = None
    edit_permissions: Optional[List[SharePermission]] = Field(default=None, description="The details of any edit share permissions for the dashboard.", alias="editPermissions")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the dashboard.")
    is_favourite: Optional[StrictBool] = Field(default=None, description="Whether the dashboard is selected as a favorite by the user.", alias="isFavourite")
    is_writable: Optional[StrictBool] = Field(default=None, description="Whether the current user has permission to edit the dashboard.", alias="isWritable")
    name: Optional[StrictStr] = Field(default=None, description="The name of the dashboard.")
    owner: Optional[UserBean] = Field(default=None, description="The owner of the dashboard.")
    popularity: Optional[StrictInt] = Field(default=None, description="The number of users who have this dashboard as a favorite.")
    rank: Optional[StrictInt] = Field(default=None, description="The rank of this dashboard.")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of these dashboard details.", alias="self")
    share_permissions: Optional[List[SharePermission]] = Field(default=None, description="The details of any view share permissions for the dashboard.", alias="sharePermissions")
    system_dashboard: Optional[StrictBool] = Field(default=None, description="Whether the current dashboard is system dashboard.", alias="systemDashboard")
    view: Optional[StrictStr] = Field(default=None, description="The URL of the dashboard.")
    __properties: ClassVar[List[str]] = ["automaticRefreshMs", "description", "editPermissions", "id", "isFavourite", "isWritable", "name", "owner", "popularity", "rank", "self", "sharePermissions", "systemDashboard", "view"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Dashboard from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "automatic_refresh_ms",
            "edit_permissions",
            "id",
            "is_favourite",
            "is_writable",
            "name",
            "owner",
            "popularity",
            "rank",
            "var_self",
            "share_permissions",
            "system_dashboard",
            "view",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in edit_permissions (list)
        _items = []
        if self.edit_permissions:
            for _item_edit_permissions in self.edit_permissions:
                if _item_edit_permissions:
                    _items.append(_item_edit_permissions.to_dict())
            _dict['editPermissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in share_permissions (list)
        _items = []
        if self.share_permissions:
            for _item_share_permissions in self.share_permissions:
                if _item_share_permissions:
                    _items.append(_item_share_permissions.to_dict())
            _dict['sharePermissions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Dashboard from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "automaticRefreshMs": obj.get("automaticRefreshMs"),
            "description": obj.get("description"),
            "editPermissions": [SharePermission.from_dict(_item) for _item in obj["editPermissions"]] if obj.get("editPermissions") is not None else None,
            "id": obj.get("id"),
            "isFavourite": obj.get("isFavourite"),
            "isWritable": obj.get("isWritable"),
            "name": obj.get("name"),
            "owner": UserBean.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "popularity": obj.get("popularity"),
            "rank": obj.get("rank"),
            "self": obj.get("self"),
            "sharePermissions": [SharePermission.from_dict(_item) for _item in obj["sharePermissions"]] if obj.get("sharePermissions") is not None else None,
            "systemDashboard": obj.get("systemDashboard"),
            "view": obj.get("view")
        })
        return _obj


