# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.dashboard_gadget_position import DashboardGadgetPosition
from typing import Optional, Set
from typing_extensions import Self

class DashboardGadget(BaseModel):
    """
    Details of a gadget.
    """ # noqa: E501
    color: StrictStr = Field(description="The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.")
    id: StrictInt = Field(description="The ID of the gadget instance.")
    module_key: Optional[StrictStr] = Field(default=None, description="The module key of the gadget type.", alias="moduleKey")
    position: DashboardGadgetPosition = Field(description="The position of the gadget.")
    title: StrictStr = Field(description="The title of the gadget.")
    uri: Optional[StrictStr] = Field(default=None, description="The URI of the gadget type.")
    __properties: ClassVar[List[str]] = ["color", "id", "moduleKey", "position", "title", "uri"]

    @field_validator('color')
    def color_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['blue', 'red', 'yellow', 'green', 'cyan', 'purple', 'gray', 'white']):
            raise ValueError("must be one of enum values ('blue', 'red', 'yellow', 'green', 'cyan', 'purple', 'gray', 'white')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DashboardGadget from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "color",
            "id",
            "module_key",
            "position",
            "title",
            "uri",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DashboardGadget from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "color": obj.get("color"),
            "id": obj.get("id"),
            "moduleKey": obj.get("moduleKey"),
            "position": DashboardGadgetPosition.from_dict(obj["position"]) if obj.get("position") is not None else None,
            "title": obj.get("title"),
            "uri": obj.get("uri")
        })
        return _obj


