# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.dashboard_gadget_position import DashboardGadgetPosition
from typing import Optional, Set
from typing_extensions import Self

class DashboardGadgetSettings(BaseModel):
    """
    Details of the settings for a dashboard gadget.
    """ # noqa: E501
    color: Optional[StrictStr] = Field(default=None, description="The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.")
    ignore_uri_and_module_key_validation: Optional[StrictBool] = Field(default=None, description="Whether to ignore the validation of module key and URI. For example, when a gadget is created that is a part of an application that isn't installed.", alias="ignoreUriAndModuleKeyValidation")
    module_key: Optional[StrictStr] = Field(default=None, description="The module key of the gadget type. Can't be provided with `uri`.", alias="moduleKey")
    position: Optional[DashboardGadgetPosition] = Field(default=None, description="The position of the gadget. When the gadget is placed into the position, other gadgets in the same column are moved down to accommodate it.")
    title: Optional[StrictStr] = Field(default=None, description="The title of the gadget.")
    uri: Optional[StrictStr] = Field(default=None, description="The URI of the gadget type. Can't be provided with `moduleKey`.")
    __properties: ClassVar[List[str]] = ["color", "ignoreUriAndModuleKeyValidation", "moduleKey", "position", "title", "uri"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DashboardGadgetSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DashboardGadgetSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "color": obj.get("color"),
            "ignoreUriAndModuleKeyValidation": obj.get("ignoreUriAndModuleKeyValidation"),
            "moduleKey": obj.get("moduleKey"),
            "position": DashboardGadgetPosition.from_dict(obj["position"]) if obj.get("position") is not None else None,
            "title": obj.get("title"),
            "uri": obj.get("uri")
        })
        return _obj


