# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.custom_field_replacement import CustomFieldReplacement
from typing import Optional, Set
from typing_extensions import Self

class DeleteAndReplaceVersionBean(BaseModel):
    """
    DeleteAndReplaceVersionBean
    """ # noqa: E501
    custom_field_replacement_list: Optional[List[CustomFieldReplacement]] = Field(default=None, description="An array of custom field IDs (`customFieldId`) and version IDs (`moveTo`) to update when the fields contain the deleted version.", alias="customFieldReplacementList")
    move_affected_issues_to: Optional[StrictInt] = Field(default=None, description="The ID of the version to update `affectedVersion` to when the field contains the deleted version.", alias="moveAffectedIssuesTo")
    move_fix_issues_to: Optional[StrictInt] = Field(default=None, description="The ID of the version to update `fixVersion` to when the field contains the deleted version.", alias="moveFixIssuesTo")
    __properties: ClassVar[List[str]] = ["customFieldReplacementList", "moveAffectedIssuesTo", "moveFixIssuesTo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeleteAndReplaceVersionBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_field_replacement_list (list)
        _items = []
        if self.custom_field_replacement_list:
            for _item_custom_field_replacement_list in self.custom_field_replacement_list:
                if _item_custom_field_replacement_list:
                    _items.append(_item_custom_field_replacement_list.to_dict())
            _dict['customFieldReplacementList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeleteAndReplaceVersionBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customFieldReplacementList": [CustomFieldReplacement.from_dict(_item) for _item in obj["customFieldReplacementList"]] if obj.get("customFieldReplacementList") is not None else None,
            "moveAffectedIssuesTo": obj.get("moveAffectedIssuesTo"),
            "moveFixIssuesTo": obj.get("moveFixIssuesTo")
        })
        return _obj


