# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud.models.custom_template_options import CustomTemplateOptions
from typing import Optional, Set
from typing_extensions import Self

class EditTemplateRequest(BaseModel):
    """
    Request to edit a custom template
    """ # noqa: E501
    template_description: Optional[Annotated[str, Field(strict=True, max_length=150)]] = Field(default=None, description="The description of the template", alias="templateDescription")
    template_generation_options: Optional[CustomTemplateOptions] = Field(default=None, alias="templateGenerationOptions")
    template_key: Optional[StrictStr] = Field(default=None, description="The unique identifier of the template", alias="templateKey")
    template_name: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="The name of the template", alias="templateName")
    __properties: ClassVar[List[str]] = ["templateDescription", "templateGenerationOptions", "templateKey", "templateName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EditTemplateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of template_generation_options
        if self.template_generation_options:
            _dict['templateGenerationOptions'] = self.template_generation_options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EditTemplateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "templateDescription": obj.get("templateDescription"),
            "templateGenerationOptions": CustomTemplateOptions.from_dict(obj["templateGenerationOptions"]) if obj.get("templateGenerationOptions") is not None else None,
            "templateKey": obj.get("templateKey"),
            "templateName": obj.get("templateName")
        })
        return _obj


