# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.error import Error
from typing import Optional, Set
from typing_extensions import Self

class Errors(BaseModel):
    """
    Errors
    """ # noqa: E501
    issue_is_subtask: Optional[Error] = Field(default=None, alias="issueIsSubtask")
    issues_in_archived_projects: Optional[Error] = Field(default=None, alias="issuesInArchivedProjects")
    issues_in_unlicensed_projects: Optional[Error] = Field(default=None, alias="issuesInUnlicensedProjects")
    issues_not_found: Optional[Error] = Field(default=None, alias="issuesNotFound")
    user_does_not_have_permission: Optional[Error] = Field(default=None, alias="userDoesNotHavePermission")
    __properties: ClassVar[List[str]] = ["issueIsSubtask", "issuesInArchivedProjects", "issuesInUnlicensedProjects", "issuesNotFound", "userDoesNotHavePermission"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Errors from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of issue_is_subtask
        if self.issue_is_subtask:
            _dict['issueIsSubtask'] = self.issue_is_subtask.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issues_in_archived_projects
        if self.issues_in_archived_projects:
            _dict['issuesInArchivedProjects'] = self.issues_in_archived_projects.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issues_in_unlicensed_projects
        if self.issues_in_unlicensed_projects:
            _dict['issuesInUnlicensedProjects'] = self.issues_in_unlicensed_projects.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issues_not_found
        if self.issues_not_found:
            _dict['issuesNotFound'] = self.issues_not_found.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_does_not_have_permission
        if self.user_does_not_have_permission:
            _dict['userDoesNotHavePermission'] = self.user_does_not_have_permission.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Errors from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "issueIsSubtask": Error.from_dict(obj["issueIsSubtask"]) if obj.get("issueIsSubtask") is not None else None,
            "issuesInArchivedProjects": Error.from_dict(obj["issuesInArchivedProjects"]) if obj.get("issuesInArchivedProjects") is not None else None,
            "issuesInUnlicensedProjects": Error.from_dict(obj["issuesInUnlicensedProjects"]) if obj.get("issuesInUnlicensedProjects") is not None else None,
            "issuesNotFound": Error.from_dict(obj["issuesNotFound"]) if obj.get("issuesNotFound") is not None else None,
            "userDoesNotHavePermission": Error.from_dict(obj["userDoesNotHavePermission"]) if obj.get("userDoesNotHavePermission") is not None else None
        })
        return _obj


