# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.field_details import FieldDetails
from devopso.clients.jira_cloud.models.group_name import GroupName
from devopso.clients.jira_cloud.models.project_role import ProjectRole
from devopso.clients.jira_cloud.models.user_details import UserDetails
from typing import Optional, Set
from typing_extensions import Self

class EventNotification(BaseModel):
    """
    Details about a notification associated with an event.
    """ # noqa: E501
    email_address: Optional[StrictStr] = Field(default=None, description="The email address.", alias="emailAddress")
    expand: Optional[StrictStr] = Field(default=None, description="Expand options that include additional event notification details in the response.")
    var_field: Optional[FieldDetails] = Field(default=None, description="The custom user or group field.", alias="field")
    group: Optional[GroupName] = Field(default=None, description="The specified group.")
    id: Optional[StrictInt] = Field(default=None, description="The ID of the notification.")
    notification_type: Optional[StrictStr] = Field(default=None, description="Identifies the recipients of the notification.", alias="notificationType")
    parameter: Optional[StrictStr] = Field(default=None, description="As a group's name can change, use of `recipient` is recommended. The identifier associated with the `notificationType` value that defines the receiver of the notification, where the receiver isn't implied by `notificationType` value. So, when `notificationType` is:   *  `User` The `parameter` is the user account ID.  *  `Group` The `parameter` is the group name.  *  `ProjectRole` The `parameter` is the project role ID.  *  `UserCustomField` The `parameter` is the ID of the custom field.  *  `GroupCustomField` The `parameter` is the ID of the custom field.")
    project_role: Optional[ProjectRole] = Field(default=None, description="The specified project role.", alias="projectRole")
    recipient: Optional[StrictStr] = Field(default=None, description="The identifier associated with the `notificationType` value that defines the receiver of the notification, where the receiver isn't implied by the `notificationType` value. So, when `notificationType` is:   *  `User`, `recipient` is the user account ID.  *  `Group`, `recipient` is the group ID.  *  `ProjectRole`, `recipient` is the project role ID.  *  `UserCustomField`, `recipient` is the ID of the custom field.  *  `GroupCustomField`, `recipient` is the ID of the custom field.")
    user: Optional[UserDetails] = Field(default=None, description="The specified user.")
    __properties: ClassVar[List[str]] = ["emailAddress", "expand", "field", "group", "id", "notificationType", "parameter", "projectRole", "recipient", "user"]

    @field_validator('notification_type')
    def notification_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CurrentAssignee', 'Reporter', 'CurrentUser', 'ProjectLead', 'ComponentLead', 'User', 'Group', 'ProjectRole', 'EmailAddress', 'AllWatchers', 'UserCustomField', 'GroupCustomField']):
            raise ValueError("must be one of enum values ('CurrentAssignee', 'Reporter', 'CurrentUser', 'ProjectLead', 'ComponentLead', 'User', 'Group', 'ProjectRole', 'EmailAddress', 'AllWatchers', 'UserCustomField', 'GroupCustomField')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventNotification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_field
        if self.var_field:
            _dict['field'] = self.var_field.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project_role
        if self.project_role:
            _dict['projectRole'] = self.project_role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventNotification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "emailAddress": obj.get("emailAddress"),
            "expand": obj.get("expand"),
            "field": FieldDetails.from_dict(obj["field"]) if obj.get("field") is not None else None,
            "group": GroupName.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "id": obj.get("id"),
            "notificationType": obj.get("notificationType"),
            "parameter": obj.get("parameter"),
            "projectRole": ProjectRole.from_dict(obj["projectRole"]) if obj.get("projectRole") is not None else None,
            "recipient": obj.get("recipient"),
            "user": UserDetails.from_dict(obj["user"]) if obj.get("user") is not None else None
        })
        return _obj


