# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.custom_field_payload import CustomFieldPayload
from devopso.clients.jira_cloud.models.field_layout_payload import FieldLayoutPayload
from devopso.clients.jira_cloud.models.field_layout_scheme_payload import FieldLayoutSchemePayload
from devopso.clients.jira_cloud.models.issue_layout_payload import IssueLayoutPayload
from devopso.clients.jira_cloud.models.issue_type_screen_scheme_payload import IssueTypeScreenSchemePayload
from devopso.clients.jira_cloud.models.screen_payload import ScreenPayload
from devopso.clients.jira_cloud.models.screen_scheme_payload import ScreenSchemePayload
from typing import Optional, Set
from typing_extensions import Self

class FieldCapabilityPayload(BaseModel):
    """
    Defines the payload for the fields, screens, screen schemes, issue type screen schemes, field layouts, and field layout schemes
    """ # noqa: E501
    custom_field_definitions: Optional[List[Optional[CustomFieldPayload]]] = Field(default=None, description="The custom field definitions. See https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-issue-fields/\\#api-rest-api-3-field-post", alias="customFieldDefinitions")
    field_layout_scheme: Optional[FieldLayoutSchemePayload] = Field(default=None, alias="fieldLayoutScheme")
    field_layouts: Optional[List[Optional[FieldLayoutPayload]]] = Field(default=None, description="The field layouts configuration.", alias="fieldLayouts")
    issue_layouts: Optional[List[Optional[IssueLayoutPayload]]] = Field(default=None, description="The issue layouts configuration", alias="issueLayouts")
    issue_type_screen_scheme: Optional[IssueTypeScreenSchemePayload] = Field(default=None, alias="issueTypeScreenScheme")
    screen_scheme: Optional[List[Optional[ScreenSchemePayload]]] = Field(default=None, description="The screen schemes See https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-screen-schemes/\\#api-rest-api-3-screenscheme-post", alias="screenScheme")
    screens: Optional[List[Optional[ScreenPayload]]] = Field(default=None, description="The screens. See https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-screens/\\#api-rest-api-3-screens-post")
    __properties: ClassVar[List[str]] = ["customFieldDefinitions", "fieldLayoutScheme", "fieldLayouts", "issueLayouts", "issueTypeScreenScheme", "screenScheme", "screens"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldCapabilityPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_field_definitions (list)
        _items = []
        if self.custom_field_definitions:
            for _item_custom_field_definitions in self.custom_field_definitions:
                if _item_custom_field_definitions:
                    _items.append(_item_custom_field_definitions.to_dict())
            _dict['customFieldDefinitions'] = _items
        # override the default output from pydantic by calling `to_dict()` of field_layout_scheme
        if self.field_layout_scheme:
            _dict['fieldLayoutScheme'] = self.field_layout_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in field_layouts (list)
        _items = []
        if self.field_layouts:
            for _item_field_layouts in self.field_layouts:
                if _item_field_layouts:
                    _items.append(_item_field_layouts.to_dict())
            _dict['fieldLayouts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in issue_layouts (list)
        _items = []
        if self.issue_layouts:
            for _item_issue_layouts in self.issue_layouts:
                if _item_issue_layouts:
                    _items.append(_item_issue_layouts.to_dict())
            _dict['issueLayouts'] = _items
        # override the default output from pydantic by calling `to_dict()` of issue_type_screen_scheme
        if self.issue_type_screen_scheme:
            _dict['issueTypeScreenScheme'] = self.issue_type_screen_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in screen_scheme (list)
        _items = []
        if self.screen_scheme:
            for _item_screen_scheme in self.screen_scheme:
                if _item_screen_scheme:
                    _items.append(_item_screen_scheme.to_dict())
            _dict['screenScheme'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in screens (list)
        _items = []
        if self.screens:
            for _item_screens in self.screens:
                if _item_screens:
                    _items.append(_item_screens.to_dict())
            _dict['screens'] = _items
        # set to None if custom_field_definitions (nullable) is None
        # and model_fields_set contains the field
        if self.custom_field_definitions is None and "custom_field_definitions" in self.model_fields_set:
            _dict['customFieldDefinitions'] = None

        # set to None if field_layout_scheme (nullable) is None
        # and model_fields_set contains the field
        if self.field_layout_scheme is None and "field_layout_scheme" in self.model_fields_set:
            _dict['fieldLayoutScheme'] = None

        # set to None if field_layouts (nullable) is None
        # and model_fields_set contains the field
        if self.field_layouts is None and "field_layouts" in self.model_fields_set:
            _dict['fieldLayouts'] = None

        # set to None if issue_layouts (nullable) is None
        # and model_fields_set contains the field
        if self.issue_layouts is None and "issue_layouts" in self.model_fields_set:
            _dict['issueLayouts'] = None

        # set to None if issue_type_screen_scheme (nullable) is None
        # and model_fields_set contains the field
        if self.issue_type_screen_scheme is None and "issue_type_screen_scheme" in self.model_fields_set:
            _dict['issueTypeScreenScheme'] = None

        # set to None if screen_scheme (nullable) is None
        # and model_fields_set contains the field
        if self.screen_scheme is None and "screen_scheme" in self.model_fields_set:
            _dict['screenScheme'] = None

        # set to None if screens (nullable) is None
        # and model_fields_set contains the field
        if self.screens is None and "screens" in self.model_fields_set:
            _dict['screens'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldCapabilityPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customFieldDefinitions": [CustomFieldPayload.from_dict(_item) for _item in obj["customFieldDefinitions"]] if obj.get("customFieldDefinitions") is not None else None,
            "fieldLayoutScheme": FieldLayoutSchemePayload.from_dict(obj["fieldLayoutScheme"]) if obj.get("fieldLayoutScheme") is not None else None,
            "fieldLayouts": [FieldLayoutPayload.from_dict(_item) for _item in obj["fieldLayouts"]] if obj.get("fieldLayouts") is not None else None,
            "issueLayouts": [IssueLayoutPayload.from_dict(_item) for _item in obj["issueLayouts"]] if obj.get("issueLayouts") is not None else None,
            "issueTypeScreenScheme": IssueTypeScreenSchemePayload.from_dict(obj["issueTypeScreenScheme"]) if obj.get("issueTypeScreenScheme") is not None else None,
            "screenScheme": [ScreenSchemePayload.from_dict(_item) for _item in obj["screenScheme"]] if obj.get("screenScheme") is not None else None,
            "screens": [ScreenPayload.from_dict(_item) for _item in obj["screens"]] if obj.get("screens") is not None else None
        })
        return _obj


