# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.json_type_bean import JsonTypeBean
from typing import Optional, Set
from typing_extensions import Self

class FieldCreateMetadata(BaseModel):
    """
    The metadata describing an issue field for createmeta.
    """ # noqa: E501
    allowed_values: Optional[List[Any]] = Field(default=None, description="The list of values allowed in the field.", alias="allowedValues")
    auto_complete_url: Optional[StrictStr] = Field(default=None, description="The URL that can be used to automatically complete the field.", alias="autoCompleteUrl")
    configuration: Optional[Dict[str, Any]] = Field(default=None, description="The configuration properties.")
    default_value: Optional[Any] = Field(default=None, description="The default value of the field.", alias="defaultValue")
    field_id: StrictStr = Field(description="The field id.", alias="fieldId")
    has_default_value: Optional[StrictBool] = Field(default=None, description="Whether the field has a default value.", alias="hasDefaultValue")
    key: StrictStr = Field(description="The key of the field.")
    name: StrictStr = Field(description="The name of the field.")
    operations: List[StrictStr] = Field(description="The list of operations that can be performed on the field.")
    required: StrictBool = Field(description="Whether the field is required.")
    var_schema: JsonTypeBean = Field(description="The data type of the field.", alias="schema")
    __properties: ClassVar[List[str]] = ["allowedValues", "autoCompleteUrl", "configuration", "defaultValue", "fieldId", "hasDefaultValue", "key", "name", "operations", "required", "schema"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldCreateMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "allowed_values",
            "auto_complete_url",
            "configuration",
            "default_value",
            "field_id",
            "has_default_value",
            "key",
            "name",
            "operations",
            "required",
            "var_schema",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        # set to None if default_value (nullable) is None
        # and model_fields_set contains the field
        if self.default_value is None and "default_value" in self.model_fields_set:
            _dict['defaultValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldCreateMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowedValues": obj.get("allowedValues"),
            "autoCompleteUrl": obj.get("autoCompleteUrl"),
            "configuration": obj.get("configuration"),
            "defaultValue": obj.get("defaultValue"),
            "fieldId": obj.get("fieldId"),
            "hasDefaultValue": obj.get("hasDefaultValue"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "operations": obj.get("operations"),
            "required": obj.get("required"),
            "schema": JsonTypeBean.from_dict(obj["schema"]) if obj.get("schema") is not None else None
        })
        return _obj


