# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FieldReferenceData(BaseModel):
    """
    Details of a field that can be used in advanced searches.
    """ # noqa: E501
    auto: Optional[StrictStr] = Field(default=None, description="Whether the field provide auto-complete suggestions.")
    cfid: Optional[StrictStr] = Field(default=None, description="If the item is a custom field, the ID of the custom field.")
    deprecated: Optional[StrictStr] = Field(default=None, description="Whether this field has been deprecated.")
    deprecated_searcher_key: Optional[StrictStr] = Field(default=None, description="The searcher key of the field, only passed when the field is deprecated.", alias="deprecatedSearcherKey")
    display_name: Optional[StrictStr] = Field(default=None, description="The display name contains the following:   *  for system fields, the field name. For example, `Summary`.  *  for collapsed custom fields, the field name followed by a hyphen and then the field name and field type. For example, `Component - Component[Dropdown]`.  *  for other custom fields, the field name followed by a hyphen and then the custom field ID. For example, `Component - cf[10061]`.", alias="displayName")
    operators: Optional[List[StrictStr]] = Field(default=None, description="The valid search operators for the field.")
    orderable: Optional[StrictStr] = Field(default=None, description="Whether the field can be used in a query's `ORDER BY` clause.")
    searchable: Optional[StrictStr] = Field(default=None, description="Whether the content of this field can be searched.")
    types: Optional[List[StrictStr]] = Field(default=None, description="The data types of items in the field.")
    value: Optional[StrictStr] = Field(default=None, description="The field identifier.")
    __properties: ClassVar[List[str]] = ["auto", "cfid", "deprecated", "deprecatedSearcherKey", "displayName", "operators", "orderable", "searchable", "types", "value"]

    @field_validator('auto')
    def auto_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    @field_validator('deprecated')
    def deprecated_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    @field_validator('orderable')
    def orderable_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    @field_validator('searchable')
    def searchable_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldReferenceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldReferenceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "auto": obj.get("auto"),
            "cfid": obj.get("cfid"),
            "deprecated": obj.get("deprecated"),
            "deprecatedSearcherKey": obj.get("deprecatedSearcherKey"),
            "displayName": obj.get("displayName"),
            "operators": obj.get("operators"),
            "orderable": obj.get("orderable"),
            "searchable": obj.get("searchable"),
            "types": obj.get("types"),
            "value": obj.get("value")
        })
        return _obj


