# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from devopso.clients.jira_cloud.models.jql_query_clause_operand import JqlQueryClauseOperand
from devopso.clients.jira_cloud.models.jql_query_clause_time_predicate import JqlQueryClauseTimePredicate
from devopso.clients.jira_cloud.models.jql_query_field import JqlQueryField
from typing import Optional, Set
from typing_extensions import Self

class FieldWasClause(BaseModel):
    """
    A clause that asserts a previous value of a field. For example, `status WAS \"Resolved\" BY currentUser() BEFORE \"2019/02/02\"`. See [WAS](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-WASWAS) for more information about the WAS operator.
    """ # noqa: E501
    var_field: JqlQueryField = Field(alias="field")
    operand: JqlQueryClauseOperand
    operator: StrictStr = Field(description="The operator between the field and operand.")
    predicates: List[JqlQueryClauseTimePredicate] = Field(description="The list of time predicates.")
    __properties: ClassVar[List[str]] = ["field", "operand", "operator", "predicates"]

    @field_validator('operator')
    def operator_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['was', 'was in', 'was not in', 'was not']):
            raise ValueError("must be one of enum values ('was', 'was in', 'was not in', 'was not')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FieldWasClause from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_field
        if self.var_field:
            _dict['field'] = self.var_field.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operand
        if self.operand:
            _dict['operand'] = self.operand.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in predicates (list)
        _items = []
        if self.predicates:
            for _item_predicates in self.predicates:
                if _item_predicates:
                    _items.append(_item_predicates.to_dict())
            _dict['predicates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FieldWasClause from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "field": JqlQueryField.from_dict(obj["field"]) if obj.get("field") is not None else None,
            "operand": JqlQueryClauseOperand.from_dict(obj["operand"]) if obj.get("operand") is not None else None,
            "operator": obj.get("operator"),
            "predicates": [JqlQueryClauseTimePredicate.from_dict(_item) for _item in obj["predicates"]] if obj.get("predicates") is not None else None
        })
        return _obj


