# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.group_label import GroupLabel
from typing import Optional, Set
from typing_extensions import Self

class FoundGroup(BaseModel):
    """
    A group found in a search.
    """ # noqa: E501
    avatar_url: Optional[StrictStr] = Field(default=None, description="Avatar url for the group/team if present.", alias="avatarUrl")
    group_id: Optional[StrictStr] = Field(default=None, description="The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.", alias="groupId")
    html: Optional[StrictStr] = Field(default=None, description="The group name with the matched query string highlighted with the HTML bold tag.")
    labels: Optional[List[GroupLabel]] = None
    managed_by: Optional[StrictStr] = Field(default=None, description="Describes who/how the team is managed. The possible values are   \\* external - when team is synced from an external directory like SCIM or HRIS, and team members cannot be modified.   \\* admins - when a team is managed by an admin (team members can only be modified by admins).   \\* team-members - managed by existing team members, new members need to be invited to join.   \\* open - anyone can join or modify this team.", alias="managedBy")
    name: Optional[StrictStr] = Field(default=None, description="The name of the group. The name of a group is mutable, to reliably identify a group use ``groupId`.`")
    usage_type: Optional[StrictStr] = Field(default=None, description="Describes the type of group. The possible values are   \\* team-collaboration - A platform team managed in people directory.   \\* userbase-group - a group of users created in adminhub.   \\* admin-oversight - currently unused.", alias="usageType")
    __properties: ClassVar[List[str]] = ["avatarUrl", "groupId", "html", "labels", "managedBy", "name", "usageType"]

    @field_validator('managed_by')
    def managed_by_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['EXTERNAL', 'ADMINS', 'TEAM_MEMBERS', 'OPEN']):
            raise ValueError("must be one of enum values ('EXTERNAL', 'ADMINS', 'TEAM_MEMBERS', 'OPEN')")
        return value

    @field_validator('usage_type')
    def usage_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['USERBASE_GROUP', 'TEAM_COLLABORATION', 'ADMIN_OVERSIGHT']):
            raise ValueError("must be one of enum values ('USERBASE_GROUP', 'TEAM_COLLABORATION', 'ADMIN_OVERSIGHT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FoundGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item_labels in self.labels:
                if _item_labels:
                    _items.append(_item_labels.to_dict())
            _dict['labels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FoundGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatarUrl": obj.get("avatarUrl"),
            "groupId": obj.get("groupId"),
            "html": obj.get("html"),
            "labels": [GroupLabel.from_dict(_item) for _item in obj["labels"]] if obj.get("labels") is not None else None,
            "managedBy": obj.get("managedBy"),
            "name": obj.get("name"),
            "usageType": obj.get("usageType")
        })
        return _obj


