# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FunctionReferenceData(BaseModel):
    """
    Details of functions that can be used in advanced searches.
    """ # noqa: E501
    display_name: Optional[StrictStr] = Field(default=None, description="The display name of the function.", alias="displayName")
    is_list: Optional[StrictStr] = Field(default=None, description="Whether the function can take a list of arguments.", alias="isList")
    supports_list_and_single_value_operators: Optional[StrictStr] = Field(default=None, description="Whether the function supports both single and list value operators.", alias="supportsListAndSingleValueOperators")
    types: Optional[List[StrictStr]] = Field(default=None, description="The data types returned by the function.")
    value: Optional[StrictStr] = Field(default=None, description="The function identifier.")
    __properties: ClassVar[List[str]] = ["displayName", "isList", "supportsListAndSingleValueOperators", "types", "value"]

    @field_validator('is_list')
    def is_list_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    @field_validator('supports_list_and_single_value_operators')
    def supports_list_and_single_value_operators_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionReferenceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionReferenceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "displayName": obj.get("displayName"),
            "isList": obj.get("isList"),
            "supportsListAndSingleValueOperators": obj.get("supportsListAndSingleValueOperators"),
            "types": obj.get("types"),
            "value": obj.get("value")
        })
        return _obj


