# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class GetAtlassianTeamResponse(BaseModel):
    """
    GetAtlassianTeamResponse
    """ # noqa: E501
    capacity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The capacity for the Atlassian team.")
    id: StrictStr = Field(description="The Atlassian team ID.")
    issue_source_id: Optional[StrictInt] = Field(default=None, description="The ID of the issue source for the Atlassian team.", alias="issueSourceId")
    planning_style: StrictStr = Field(description="The planning style for the Atlassian team. This is \"Scrum\" or \"Kanban\".", alias="planningStyle")
    sprint_length: Optional[StrictInt] = Field(default=None, description="The sprint length for the Atlassian team.", alias="sprintLength")
    __properties: ClassVar[List[str]] = ["capacity", "id", "issueSourceId", "planningStyle", "sprintLength"]

    @field_validator('planning_style')
    def planning_style_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Scrum', 'Kanban']):
            raise ValueError("must be one of enum values ('Scrum', 'Kanban')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAtlassianTeamResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAtlassianTeamResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "capacity": obj.get("capacity"),
            "id": obj.get("id"),
            "issueSourceId": obj.get("issueSourceId"),
            "planningStyle": obj.get("planningStyle"),
            "sprintLength": obj.get("sprintLength")
        })
        return _obj


