# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.get_issue_source_response import GetIssueSourceResponse
from typing import Optional, Set
from typing_extensions import Self

class GetPlanResponseForPage(BaseModel):
    """
    GetPlanResponseForPage
    """ # noqa: E501
    id: StrictStr = Field(description="The plan ID.")
    issue_sources: Optional[List[GetIssueSourceResponse]] = Field(default=None, description="The issue sources included in the plan.", alias="issueSources")
    name: StrictStr = Field(description="The plan name.")
    scenario_id: StrictStr = Field(description="Default scenario ID.", alias="scenarioId")
    status: StrictStr = Field(description="The plan status. This is \"Active\", \"Trashed\" or \"Archived\".")
    __properties: ClassVar[List[str]] = ["id", "issueSources", "name", "scenarioId", "status"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Active', 'Trashed', 'Archived']):
            raise ValueError("must be one of enum values ('Active', 'Trashed', 'Archived')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetPlanResponseForPage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in issue_sources (list)
        _items = []
        if self.issue_sources:
            for _item_issue_sources in self.issue_sources:
                if _item_issue_sources:
                    _items.append(_item_issue_sources.to_dict())
            _dict['issueSources'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetPlanResponseForPage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "issueSources": [GetIssueSourceResponse.from_dict(_item) for _item in obj["issueSources"]] if obj.get("issueSources") is not None else None,
            "name": obj.get("name"),
            "scenarioId": obj.get("scenarioId"),
            "status": obj.get("status")
        })
        return _obj


