# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from devopso.clients.jira_cloud.models.get_date_field_response import GetDateFieldResponse
from typing import Optional, Set
from typing_extensions import Self

class GetSchedulingResponse(BaseModel):
    """
    GetSchedulingResponse
    """ # noqa: E501
    dependencies: StrictStr = Field(description="The dependencies for the plan. This is \"Sequential\" or \"Concurrent\".")
    end_date: GetDateFieldResponse = Field(description="The end date field for the plan.", alias="endDate")
    estimation: StrictStr = Field(description="The estimation unit for the plan. This is \"StoryPoints\", \"Days\" or \"Hours\".")
    inferred_dates: StrictStr = Field(description="The inferred dates for the plan. This is \"None\", \"SprintDates\" or \"ReleaseDates\".", alias="inferredDates")
    start_date: GetDateFieldResponse = Field(description="The start date field for the plan.", alias="startDate")
    __properties: ClassVar[List[str]] = ["dependencies", "endDate", "estimation", "inferredDates", "startDate"]

    @field_validator('dependencies')
    def dependencies_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Sequential', 'Concurrent']):
            raise ValueError("must be one of enum values ('Sequential', 'Concurrent')")
        return value

    @field_validator('estimation')
    def estimation_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['StoryPoints', 'Days', 'Hours']):
            raise ValueError("must be one of enum values ('StoryPoints', 'Days', 'Hours')")
        return value

    @field_validator('inferred_dates')
    def inferred_dates_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['None', 'SprintDates', 'ReleaseDates']):
            raise ValueError("must be one of enum values ('None', 'SprintDates', 'ReleaseDates')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetSchedulingResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of end_date
        if self.end_date:
            _dict['endDate'] = self.end_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of start_date
        if self.start_date:
            _dict['startDate'] = self.start_date.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetSchedulingResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dependencies": obj.get("dependencies"),
            "endDate": GetDateFieldResponse.from_dict(obj["endDate"]) if obj.get("endDate") is not None else None,
            "estimation": obj.get("estimation"),
            "inferredDates": obj.get("inferredDates"),
            "startDate": GetDateFieldResponse.from_dict(obj["startDate"]) if obj.get("startDate") is not None else None
        })
        return _obj


