# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.included_fields import IncludedFields
from devopso.clients.jira_cloud.models.issue_transition import IssueTransition
from devopso.clients.jira_cloud.models.issue_update_metadata import IssueUpdateMetadata
from devopso.clients.jira_cloud.models.json_type_bean import JsonTypeBean
from devopso.clients.jira_cloud.models.operations import Operations
from devopso.clients.jira_cloud.models.page_of_changelogs import PageOfChangelogs
from typing import Optional, Set
from typing_extensions import Self

class IssueBean(BaseModel):
    """
    Details about an issue.
    """ # noqa: E501
    changelog: Optional[PageOfChangelogs] = Field(default=None, description="Details of changelogs associated with the issue.")
    editmeta: Optional[IssueUpdateMetadata] = Field(default=None, description="The metadata for the fields on the issue that can be amended.")
    expand: Optional[StrictStr] = Field(default=None, description="Expand options that include additional issue details in the response.")
    fields: Optional[Dict[str, Any]] = None
    fields_to_include: Optional[IncludedFields] = Field(default=None, alias="fieldsToInclude")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the issue.")
    key: Optional[StrictStr] = Field(default=None, description="The key of the issue.")
    names: Optional[Dict[str, StrictStr]] = Field(default=None, description="The ID and name of each field present on the issue.")
    operations: Optional[Operations] = Field(default=None, description="The operations that can be performed on the issue.")
    properties: Optional[Dict[str, Any]] = Field(default=None, description="Details of the issue properties identified in the request.")
    rendered_fields: Optional[Dict[str, Any]] = Field(default=None, description="The rendered value of each field present on the issue.", alias="renderedFields")
    var_schema: Optional[Dict[str, JsonTypeBean]] = Field(default=None, description="The schema describing each field present on the issue.", alias="schema")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the issue details.", alias="self")
    transitions: Optional[List[IssueTransition]] = Field(default=None, description="The transitions that can be performed on the issue.")
    versioned_representations: Optional[Dict[str, Dict[str, Any]]] = Field(default=None, description="The versions of each field on the issue.", alias="versionedRepresentations")
    __properties: ClassVar[List[str]] = ["changelog", "editmeta", "expand", "fields", "fieldsToInclude", "id", "key", "names", "operations", "properties", "renderedFields", "schema", "self", "transitions", "versionedRepresentations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "changelog",
            "editmeta",
            "expand",
            "id",
            "key",
            "names",
            "operations",
            "properties",
            "rendered_fields",
            "var_schema",
            "var_self",
            "transitions",
            "versioned_representations",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of changelog
        if self.changelog:
            _dict['changelog'] = self.changelog.to_dict()
        # override the default output from pydantic by calling `to_dict()` of editmeta
        if self.editmeta:
            _dict['editmeta'] = self.editmeta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fields_to_include
        if self.fields_to_include:
            _dict['fieldsToInclude'] = self.fields_to_include.to_dict()
        # override the default output from pydantic by calling `to_dict()` of operations
        if self.operations:
            _dict['operations'] = self.operations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in var_schema (dict)
        _field_dict = {}
        if self.var_schema:
            for _key_var_schema in self.var_schema:
                if self.var_schema[_key_var_schema]:
                    _field_dict[_key_var_schema] = self.var_schema[_key_var_schema].to_dict()
            _dict['schema'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in transitions (list)
        _items = []
        if self.transitions:
            for _item_transitions in self.transitions:
                if _item_transitions:
                    _items.append(_item_transitions.to_dict())
            _dict['transitions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "changelog": PageOfChangelogs.from_dict(obj["changelog"]) if obj.get("changelog") is not None else None,
            "editmeta": IssueUpdateMetadata.from_dict(obj["editmeta"]) if obj.get("editmeta") is not None else None,
            "expand": obj.get("expand"),
            "fields": obj.get("fields"),
            "fieldsToInclude": IncludedFields.from_dict(obj["fieldsToInclude"]) if obj.get("fieldsToInclude") is not None else None,
            "id": obj.get("id"),
            "key": obj.get("key"),
            "names": obj.get("names"),
            "operations": Operations.from_dict(obj["operations"]) if obj.get("operations") is not None else None,
            "properties": obj.get("properties"),
            "renderedFields": obj.get("renderedFields"),
            "schema": dict(
                (_k, JsonTypeBean.from_dict(_v))
                for _k, _v in obj["schema"].items()
            )
            if obj.get("schema") is not None
            else None,
            "self": obj.get("self"),
            "transitions": [IssueTransition.from_dict(_item) for _item in obj["transitions"]] if obj.get("transitions") is not None else None,
            "versionedRepresentations": obj.get("versionedRepresentations")
        })
        return _obj


