# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IssueBulkEditField(BaseModel):
    """
    IssueBulkEditField
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="Description of the field.")
    field_options: Optional[List[Dict[str, Any]]] = Field(default=None, description="A list of options related to the field, applicable in contexts where multiple selections are allowed.", alias="fieldOptions")
    id: Optional[StrictStr] = Field(default=None, description="The unique ID of the field.")
    is_required: Optional[StrictBool] = Field(default=None, description="Indicates whether the field is mandatory for the operation.", alias="isRequired")
    multi_select_field_options: Optional[List[StrictStr]] = Field(default=None, description="Specifies supported actions (like add, replace, remove) on multi-select fields via an enum.", alias="multiSelectFieldOptions")
    name: Optional[StrictStr] = Field(default=None, description="The display name of the field.")
    search_url: Optional[StrictStr] = Field(default=None, description="A URL to fetch additional data for the field", alias="searchUrl")
    type: Optional[StrictStr] = Field(default=None, description="The type of the field.")
    unavailable_message: Optional[StrictStr] = Field(default=None, description="A message indicating why the field is unavailable for editing.", alias="unavailableMessage")
    __properties: ClassVar[List[str]] = ["description", "fieldOptions", "id", "isRequired", "multiSelectFieldOptions", "name", "searchUrl", "type", "unavailableMessage"]

    @field_validator('multi_select_field_options')
    def multi_select_field_options_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['ADD', 'REMOVE', 'REPLACE', 'REMOVE_ALL']):
                raise ValueError("each list item must be one of ('ADD', 'REMOVE', 'REPLACE', 'REMOVE_ALL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueBulkEditField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueBulkEditField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "fieldOptions": obj.get("fieldOptions"),
            "id": obj.get("id"),
            "isRequired": obj.get("isRequired"),
            "multiSelectFieldOptions": obj.get("multiSelectFieldOptions"),
            "name": obj.get("name"),
            "searchUrl": obj.get("searchUrl"),
            "type": obj.get("type"),
            "unavailableMessage": obj.get("unavailableMessage")
        })
        return _obj


