# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.target_to_sources_mapping import TargetToSourcesMapping
from typing import Optional, Set
from typing_extensions import Self

class IssueBulkMovePayload(BaseModel):
    """
    Issue Bulk Move Payload
    """ # noqa: E501
    send_bulk_notification: Optional[StrictBool] = Field(default=True, description="A boolean value that indicates whether to send a bulk change notification when the issues are being moved.  If `true`, dispatches a bulk notification email to users about the updates.", alias="sendBulkNotification")
    target_to_sources_mapping: Optional[Dict[str, TargetToSourcesMapping]] = Field(default=None, description="An object representing the mapping of issues and data related to destination entities, like fields and statuses, that are required during a bulk move.  The key is a string that is created by concatenating the following three entities in order, separated by commas. The format is `<project ID or key>,<issueType ID>,<parent ID or key>`. It should be unique across mappings provided in the payload. If you provide multiple mappings for the same key, only one will be processed. However, the operation won't fail, so the error may be hard to track down.   *  ***Destination project*** (Required): ID or key of the project to which the issues are being moved.  *  ***Destination issueType*** (Required): ID of the issueType to which the issues are being moved.  *  ***Destination parent ID or key*** (Optional): ID or key of the issue which will become the parent of the issues being moved. Only required when the destination issueType is a subtask.", alias="targetToSourcesMapping")
    __properties: ClassVar[List[str]] = ["sendBulkNotification", "targetToSourcesMapping"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueBulkMovePayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in target_to_sources_mapping (dict)
        _field_dict = {}
        if self.target_to_sources_mapping:
            for _key_target_to_sources_mapping in self.target_to_sources_mapping:
                if self.target_to_sources_mapping[_key_target_to_sources_mapping]:
                    _field_dict[_key_target_to_sources_mapping] = self.target_to_sources_mapping[_key_target_to_sources_mapping].to_dict()
            _dict['targetToSourcesMapping'] = _field_dict
        # set to None if send_bulk_notification (nullable) is None
        # and model_fields_set contains the field
        if self.send_bulk_notification is None and "send_bulk_notification" in self.model_fields_set:
            _dict['sendBulkNotification'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueBulkMovePayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sendBulkNotification": obj.get("sendBulkNotification") if obj.get("sendBulkNotification") is not None else True,
            "targetToSourcesMapping": dict(
                (_k, TargetToSourcesMapping.from_dict(_v))
                for _k, _v in obj["targetToSourcesMapping"].items()
            )
            if obj.get("targetToSourcesMapping") is not None
            else None
        })
        return _obj


