# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.bulk_transition_submit_input import BulkTransitionSubmitInput
from typing import Optional, Set
from typing_extensions import Self

class IssueBulkTransitionPayload(BaseModel):
    """
    Issue Bulk Transition Payload
    """ # noqa: E501
    bulk_transition_inputs: List[BulkTransitionSubmitInput] = Field(description="List of objects and each object has two properties:   *  Issues that will be bulk transitioned.  *  TransitionId that corresponds to a specific transition of issues that share the same workflow.", alias="bulkTransitionInputs")
    send_bulk_notification: Optional[StrictBool] = Field(default=True, description="A boolean value that indicates whether to send a bulk change notification when the issues are being transitioned.  If `true`, dispatches a bulk notification email to users about the updates.", alias="sendBulkNotification")
    __properties: ClassVar[List[str]] = ["bulkTransitionInputs", "sendBulkNotification"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueBulkTransitionPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bulk_transition_inputs (list)
        _items = []
        if self.bulk_transition_inputs:
            for _item_bulk_transition_inputs in self.bulk_transition_inputs:
                if _item_bulk_transition_inputs:
                    _items.append(_item_bulk_transition_inputs.to_dict())
            _dict['bulkTransitionInputs'] = _items
        # set to None if send_bulk_notification (nullable) is None
        # and model_fields_set contains the field
        if self.send_bulk_notification is None and "send_bulk_notification" in self.model_fields_set:
            _dict['sendBulkNotification'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueBulkTransitionPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bulkTransitionInputs": [BulkTransitionSubmitInput.from_dict(_item) for _item in obj["bulkTransitionInputs"]] if obj.get("bulkTransitionInputs") is not None else None,
            "sendBulkNotification": obj.get("sendBulkNotification") if obj.get("sendBulkNotification") is not None else True
        })
        return _obj


