# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.global_scope_bean import GlobalScopeBean
from devopso.clients.jira_cloud.models.project_scope_bean import ProjectScopeBean
from typing import Optional, Set
from typing_extensions import Self

class IssueFieldOptionScopeBean(BaseModel):
    """
    IssueFieldOptionScopeBean
    """ # noqa: E501
    var_global: Optional[GlobalScopeBean] = Field(default=None, description="Defines the behavior of the option within the global context. If this property is set, even if set to an empty object, then the option is available in all projects.", alias="global")
    projects: Optional[List[StrictInt]] = Field(default=None, description="DEPRECATED")
    projects2: Optional[List[ProjectScopeBean]] = Field(default=None, description="Defines the projects in which the option is available and the behavior of the option within each project. Specify one object per project. The behavior of the option in a project context overrides the behavior in the global context.")
    __properties: ClassVar[List[str]] = ["global", "projects", "projects2"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueFieldOptionScopeBean from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_global
        if self.var_global:
            _dict['global'] = self.var_global.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in projects2 (list)
        _items = []
        if self.projects2:
            for _item_projects2 in self.projects2:
                if _item_projects2:
                    _items.append(_item_projects2.to_dict())
            _dict['projects2'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueFieldOptionScopeBean from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "global": GlobalScopeBean.from_dict(obj["global"]) if obj.get("global") is not None else None,
            "projects": obj.get("projects"),
            "projects2": [ProjectScopeBean.from_dict(_item) for _item in obj["projects2"]] if obj.get("projects2") is not None else None
        })
        return _obj


