# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IssueFilterForBulkPropertySet(BaseModel):
    """
    Bulk operation filter details.
    """ # noqa: E501
    current_value: Optional[Any] = Field(default=None, description="The value of properties to perform the bulk operation on.", alias="currentValue")
    entity_ids: Optional[List[StrictInt]] = Field(default=None, description="List of issues to perform the bulk operation on.", alias="entityIds")
    has_property: Optional[StrictBool] = Field(default=None, description="Whether the bulk operation occurs only when the property is present on or absent from an issue.", alias="hasProperty")
    __properties: ClassVar[List[str]] = ["currentValue", "entityIds", "hasProperty"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueFilterForBulkPropertySet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if current_value (nullable) is None
        # and model_fields_set contains the field
        if self.current_value is None and "current_value" in self.model_fields_set:
            _dict['currentValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueFilterForBulkPropertySet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currentValue": obj.get("currentValue"),
            "entityIds": obj.get("entityIds"),
            "hasProperty": obj.get("hasProperty")
        })
        return _obj


