# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class IssueLayoutItemPayload(BaseModel):
    """
    Defines the payload to configure the issue layout item for a project.
    """ # noqa: E501
    item_key: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="itemKey")
    section_type: Optional[StrictStr] = Field(default=None, description="The item section type", alias="sectionType")
    type: Optional[StrictStr] = Field(default=None, description="The item type. Currently only support FIELD")
    __properties: ClassVar[List[str]] = ["itemKey", "sectionType", "type"]

    @field_validator('section_type')
    def section_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['content', 'primaryContext', 'secondaryContext']):
            raise ValueError("must be one of enum values ('content', 'primaryContext', 'secondaryContext')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FIELD']):
            raise ValueError("must be one of enum values ('FIELD')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueLayoutItemPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of item_key
        if self.item_key:
            _dict['itemKey'] = self.item_key.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueLayoutItemPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "itemKey": ProjectCreateResourceIdentifier.from_dict(obj["itemKey"]) if obj.get("itemKey") is not None else None,
            "sectionType": obj.get("sectionType"),
            "type": obj.get("type")
        })
        return _obj


