# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.issue_layout_item_payload import IssueLayoutItemPayload
from devopso.clients.jira_cloud.models.project_create_resource_identifier import ProjectCreateResourceIdentifier
from typing import Optional, Set
from typing_extensions import Self

class IssueLayoutPayload(BaseModel):
    """
    Defines the payload to configure the issue layouts for a project.
    """ # noqa: E501
    container_id: Optional[ProjectCreateResourceIdentifier] = Field(default=None, alias="containerId")
    issue_layout_type: Optional[StrictStr] = Field(default=None, description="The issue layout type", alias="issueLayoutType")
    items: Optional[List[IssueLayoutItemPayload]] = Field(default=None, description="The configuration of items in the issue layout")
    pcri: Optional[ProjectCreateResourceIdentifier] = None
    __properties: ClassVar[List[str]] = ["containerId", "issueLayoutType", "items", "pcri"]

    @field_validator('issue_layout_type')
    def issue_layout_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ISSUE_VIEW', 'ISSUE_CREATE', 'REQUEST_FORM']):
            raise ValueError("must be one of enum values ('ISSUE_VIEW', 'ISSUE_CREATE', 'REQUEST_FORM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueLayoutPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of container_id
        if self.container_id:
            _dict['containerId'] = self.container_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of pcri
        if self.pcri:
            _dict['pcri'] = self.pcri.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueLayoutPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "containerId": ProjectCreateResourceIdentifier.from_dict(obj["containerId"]) if obj.get("containerId") is not None else None,
            "issueLayoutType": obj.get("issueLayoutType"),
            "items": [IssueLayoutItemPayload.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "pcri": ProjectCreateResourceIdentifier.from_dict(obj["pcri"]) if obj.get("pcri") is not None else None
        })
        return _obj


