# coding: utf-8

"""
    The Jira Cloud platform REST API

    Jira Cloud platform REST API documentation

    The version of the OpenAPI document: 1001.0.0-SNAPSHOT-f79806309100f55b79091ff1d6ea3c2c90b46ad9
    Contact: ecosystem@atlassian.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud.models.issue_link_type import IssueLinkType
from devopso.clients.jira_cloud.models.linked_issue import LinkedIssue
from typing import Optional, Set
from typing_extensions import Self

class IssueLink(BaseModel):
    """
    Details of a link between issues.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The ID of the issue link.")
    inward_issue: LinkedIssue = Field(description="Provides details about the linked issue. If presenting this link in a user interface, use the `inward` field of the issue link type to label the link.", alias="inwardIssue")
    outward_issue: LinkedIssue = Field(description="Provides details about the linked issue. If presenting this link in a user interface, use the `outward` field of the issue link type to label the link.", alias="outwardIssue")
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the issue link.", alias="self")
    type: IssueLinkType = Field(description="The type of link between the issues.")
    __properties: ClassVar[List[str]] = ["id", "inwardIssue", "outwardIssue", "self", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueLink from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "var_self",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of inward_issue
        if self.inward_issue:
            _dict['inwardIssue'] = self.inward_issue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outward_issue
        if self.outward_issue:
            _dict['outwardIssue'] = self.outward_issue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueLink from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "inwardIssue": LinkedIssue.from_dict(obj["inwardIssue"]) if obj.get("inwardIssue") is not None else None,
            "outwardIssue": LinkedIssue.from_dict(obj["outwardIssue"]) if obj.get("outwardIssue") is not None else None,
            "self": obj.get("self"),
            "type": IssueLinkType.from_dict(obj["type"]) if obj.get("type") is not None else None
        })
        return _obj


